/*
 * Decompiled with CFR 0.152.
 */
import functologic.game.computer.Field;
import java.util.logging.Level;
import orbital.game.FieldChangeEvent;
import orbital.game.FieldChangeListener;
import orbital.robotic.Position;

public class RhythmomachiaField
extends Field {
    private static final long serialVersionUID = 6999190027781327021L;
    private boolean hasMoved = false;
    private int numberOfAttacks = 0;
    private JointAttackCoordinator[] coordinators;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RhythmomachiaField(int n, int n2) {
        super(n, n2);
        this.coordinators = new JointAttackCoordinator[RhythmomachiaRules.curRules.getLeagues()];
        for (int i = 1; i < this.coordinators.length; ++i) {
            this.coordinators[i] = new JointAttackCoordinator();
        }
    }

    public RhythmomachiaField() {
    }

    public Object clone() throws CloneNotSupportedException {
        RhythmomachiaField rhythmomachiaField = (RhythmomachiaField)super.clone();
        rhythmomachiaField.coordinators = new JointAttackCoordinator[this.coordinators.length];
        for (int i = 1; i < rhythmomachiaField.coordinators.length; ++i) {
            rhythmomachiaField.coordinators[i] = new JointAttackCoordinator(this.coordinators[i], rhythmomachiaField);
            rhythmomachiaField.coordinators[i].init(this.coordinators[i], rhythmomachiaField);
        }
        return rhythmomachiaField;
    }

    private int getNumberOfAttacks() {
        return this.numberOfAttacks;
    }

    private void setNumberOfAttacks(int n) {
        Game.logger.log(Level.FINEST, "numberOfAttacks := {0}", new Integer(n));
        this.numberOfAttacks = n;
    }

    public JointAttackCoordinator getCoordinator() {
        return this.coordinators[this.getTurn()];
    }

    JointAttackCoordinator[] getCoordinators() {
        return this.coordinators;
    }

    private void setCoordinators(JointAttackCoordinator[] jointAttackCoordinatorArray) {
        this.coordinators = jointAttackCoordinatorArray;
    }

    public void setTurn(int n) {
        super.setTurn(n);
    }

    void doTurn(int n) {
        Game.logger.log(Level.FINEST, "doTurn");
        int n2 = this.getTurn();
        if (!this.hasMoved()) {
            throw new IllegalStateException("player " + RhythmomachiaRules.leagueDescription(this.getTurn()) + " should have moved before the end of the turn");
        }
        this.setTurn(n2 == 2 ? 1 : 2);
        this.setMoved(false);
        this.getFieldChangeMulticaster().stateChanged(new FieldChangeEvent(this, 0x10 | n, new Integer(n2)));
    }

    void doTurn() {
        this.doTurn(0);
    }

    public boolean hasMoved() {
        return this.hasMoved;
    }

    void setMoved(boolean bl) {
        Game.logger.log(Level.FINEST, "hasMoved := {0}", new Boolean(bl));
        this.setNumberOfAttacks(0);
        this.hasMoved = bl;
    }

    void doMoved(Position position, Position position2) {
        Game.logger.log(Level.FINEST, "doMoved");
        if (!$assertionsDisabled && this.hasMoved()) {
            throw new AssertionError((Object)"cannot move twice");
        }
        this.setMoved(true);
        RhythmomachiaRules.curRules.performAllAttacks(this, position, position2);
        if (this.getNumberOfAttacks() >= RhythmomachiaRules.curRules.getAttacksAfterMove()) {
            if (!$assertionsDisabled && this.getNumberOfAttacks() != 0) {
                throw new AssertionError((Object)"we've just set numberOfAttacks=0 in setMoved(true)");
            }
            if (!$assertionsDisabled && RhythmomachiaRules.curRules.getAttacksAfterMove() != 0) {
                throw new AssertionError((Object)">=0 and 0>= implies =0");
            }
            this.doTurn();
        }
    }

    boolean checkAllowAttackNow(RhythmomachiaFigure rhythmomachiaFigure, RhythmomachiaFigure rhythmomachiaFigure2) {
        Game.logger.log(Level.FINEST, "checkAllowAttackNow", new Integer(this.getNumberOfAttacks()));
        RhythmomachiaRules rhythmomachiaRules = RhythmomachiaRules.curRules;
        if (this.hasMoved()) {
            if (this.getNumberOfAttacks() + 1 > rhythmomachiaRules.getAttacksAfterMove()) {
                Game.logger.log(Level.FINER, "deny attack after move because numberOfAttacks would be {0} > {1}", new Object[]{new Integer(this.getNumberOfAttacks() + 1), new Integer(rhythmomachiaRules.getAttacksAfterMove())});
                return false;
            }
        } else if (this.getNumberOfAttacks() + 1 > rhythmomachiaRules.getAttacksBeforeMove()) {
            if (rhythmomachiaRules.isAttackInsteadOfMove()) {
                Game.logger.log(Level.FINER, "allow attack before move because even though numberOfAttacks would be {0} > {1}, it is attackInsteadOfMove={2}", new Object[]{new Integer(this.getNumberOfAttacks() + 1), new Integer(rhythmomachiaRules.getAttacksBeforeMove()), new Boolean(rhythmomachiaRules.isAttackInsteadOfMove())});
                return true;
            }
            Game.logger.log(Level.FINER, "deny attack before move because numberOfAttacks would be {0} > {1}", new Object[]{new Integer(this.getNumberOfAttacks() + 1), new Integer(rhythmomachiaRules.getAttacksBeforeMove())});
            return false;
        }
        return true;
    }

    void attackNow(RhythmomachiaFigure rhythmomachiaFigure, RhythmomachiaFigure rhythmomachiaFigure2) {
        Game.logger.log(Level.FINEST, "attackNow", new Integer(this.getNumberOfAttacks()));
        if (!this.checkAllowAttackNow(rhythmomachiaFigure, rhythmomachiaFigure2)) {
            throw new IllegalStateException("not allowed to attack now");
        }
        this.setNumberOfAttacks(this.getNumberOfAttacks() + 1);
        RhythmomachiaRules rhythmomachiaRules = RhythmomachiaRules.curRules;
        if (!this.hasMoved() && this.getNumberOfAttacks() > rhythmomachiaRules.getAttacksBeforeMove()) {
            if (!$assertionsDisabled && !rhythmomachiaRules.isAttackInsteadOfMove()) {
                throw new AssertionError((Object)"otherwise checkAllowAttackNow=false");
            }
            Game.logger.log(Level.FINER, "attack before move because even though numberOfAttacks would be {0} > {1}, it is attackInsteadOfMove={2}, so moved() and perhaps doTurn()={3}", new Object[]{new Integer(this.getNumberOfAttacks()), new Integer(rhythmomachiaRules.getAttacksBeforeMove()), new Boolean(rhythmomachiaRules.isAttackInsteadOfMove()), new Boolean(rhythmomachiaRules.getAttacksAfterMove() == 0)});
            throw new InternalError("not yet reimplemented attackInsteadOfMove");
        }
    }

    public void swap(Position position, Position position2) {
        super.swap(position, position2);
    }

    FieldChangeListener mygetFieldChangeMulticaster() {
        return super.getFieldChangeMulticaster();
    }

    static {
        $assertionsDisabled = !RhythmomachiaField.class.desiredAssertionStatus();
    }
}

