/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.CompositeStandardHeuristic;
import functologic.game.computer.FieldValuation;
import functologic.game.computer.StandardHeuristic;
import functologic.game.computer.UtilityComputer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import orbital.logic.functor.Function;
import orbital.math.MathUtilities;
import orbital.math.Values;
import orbital.math.functional.Functions;

public class StandardHeuristicTransformer
implements Function,
Serializable {
    private static final long serialVersionUID = -1162645223201713047L;
    private static final Values vf;
    private static final double tolerance = 0.01;
    private double stretch;
    private double rangeMin;
    private double rangeMax;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardHeuristicTransformer(double d, double d2, double d3) {
        if (!$assertionsDisabled && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new AssertionError((Object)("real stretch value " + d));
        }
        if (!$assertionsDisabled && (Double.isNaN(d2) || Double.isNaN(d3))) {
            throw new AssertionError((Object)("validation range " + d2 + " to " + d3 + " does not contain " + Double.NaN));
        }
        if (!$assertionsDisabled && !(d2 < Double.POSITIVE_INFINITY)) {
            throw new AssertionError((Object)("min " + d2 + " < infinity"));
        }
        if (!$assertionsDisabled && !(d3 > Double.NEGATIVE_INFINITY)) {
            throw new AssertionError((Object)("max " + d3 + " > -infinity"));
        }
        this.stretch = d;
        this.rangeMin = d2;
        this.rangeMax = d3;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(double d) {
        this.rangeMin = d;
    }

    public double getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(double d) {
        this.rangeMax = d;
    }

    public Object apply(Object object) {
        double d = ((Number)object).doubleValue();
        StandardHeuristicTransformer.validate(d, this.rangeMin, this.rangeMax, this + " calculated " + d + " *" + this.stretch);
        return StandardHeuristicTransformer.squash(this.stretch * d);
    }

    public String toString() {
        return "squash";
    }

    public static List createHeuristics(double[] dArray, double[] dArray2, double[] dArray3, List list) {
        if (dArray2 == null) {
            dArray2 = new double[dArray.length];
            Arrays.fill(dArray2, Double.NEGATIVE_INFINITY);
        }
        if (dArray3 == null) {
            dArray3 = new double[dArray.length];
            Arrays.fill(dArray3, Double.POSITIVE_INFINITY);
        }
        if (list.size() != dArray.length) {
            throw new IllegalArgumentException("incompatible array lengths of figureValuators (" + list.size() + ") and stretchingFactors (" + dArray.length + ")");
        }
        if (list.size() != dArray2.length) {
            throw new IllegalArgumentException("incompatible array lengths of figureValuators (" + list.size() + ") and rangeMin (" + dArray2.length + ")");
        }
        if (list.size() != dArray3.length) {
            throw new IllegalArgumentException("incompatible array lengths of figureValuators (" + list.size() + ") and rangeMax (" + dArray3.length + ")");
        }
        list = FieldValuation.createInstances(list);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, StandardHeuristicTransformer.compose(new StandardHeuristicTransformer(dArray[i], dArray2[i], dArray3[i]), (Function)list.get(i)));
        }
        return list;
    }

    public static Function createHeuristic(double d, double d2, double d3, Function function) {
        return StandardHeuristicTransformer.compose(new StandardHeuristicTransformer(d, d2, d3), FieldValuation.createInstance(function));
    }

    public static final Object squash(double d) {
        return Functions.tanh.apply(vf.valueOf(d));
    }

    static final void validate(double d, double d2, double d3, String string) {
        if (!$assertionsDisabled && (Double.isNaN(d2) || Double.isNaN(d3))) {
            throw new AssertionError((Object)("validation range " + d2 + " to " + d3 + " does not contain " + Double.NaN));
        }
        if (!$assertionsDisabled && !(d2 < Double.POSITIVE_INFINITY)) {
            throw new AssertionError((Object)("min " + d2 + " < infinity"));
        }
        if (!$assertionsDisabled && !(d3 > Double.NEGATIVE_INFINITY)) {
            throw new AssertionError((Object)("max " + d3 + " > -infinity"));
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            UtilityComputer.logger.log(Level.FINE, "{0} irreal {1}", new Object[]{new Double(d), string});
        } else if (d < d2 && !MathUtilities.equals(d, d2, 0.01)) {
            UtilityComputer.logger.log(Level.FINE, "{0}<{1}, {2}", new Object[]{new Double(d), d2 == Double.NEGATIVE_INFINITY ? "-infinity" : new Double(d2), string});
        } else if (d > d3 && !MathUtilities.equals(d, d2, 0.01)) {
            UtilityComputer.logger.log(Level.FINE, "{0}>{1}, {2}", new Object[]{new Double(d), d3 == Double.POSITIVE_INFINITY ? "+infinity" : new Double(d3), string});
        } else {
            return;
        }
    }

    private static Function compose(Function function, Function function2) {
        return new CompositeStandardHeuristic(function, function2);
    }

    static {
        $assertionsDisabled = !StandardHeuristicTransformer.class.desiredAssertionStatus();
        vf = Values.getDefaultInstance();
    }

    static abstract class StandardHeuristicPart
    implements StandardHeuristic,
    Serializable {
        private static final long serialVersionUID = 6637932522584870818L;
        private final double stretch;
        private final double rangeMin;
        private final double rangeMax;
        static final /* synthetic */ boolean $assertionsDisabled;

        public StandardHeuristicPart(double d, double d2, double d3) {
            if (!$assertionsDisabled && (Double.isNaN(d) || Double.isInfinite(d))) {
                throw new AssertionError((Object)("real stretch value " + d));
            }
            if (!$assertionsDisabled && (Double.isNaN(d2) || Double.isNaN(d3))) {
                throw new AssertionError((Object)("validation range " + d2 + " to " + d3 + " does not contain " + Double.NaN));
            }
            if (!$assertionsDisabled && !(d2 < Double.POSITIVE_INFINITY)) {
                throw new AssertionError((Object)("min " + d2 + " < infinity"));
            }
            if (!$assertionsDisabled && !(d3 > Double.NEGATIVE_INFINITY)) {
                throw new AssertionError((Object)("max " + d3 + " > -infinity"));
            }
            this.stretch = d;
            this.rangeMin = d2;
            this.rangeMax = d3;
        }

        protected Object transform(double d) {
            StandardHeuristicTransformer.validate(d, this.rangeMin, this.rangeMax, this + " calculated " + d + " *" + this.stretch);
            return StandardHeuristicTransformer.squash(this.stretch * d);
        }

        static {
            $assertionsDisabled = !(class$functologic$game$computer$StandardHeuristicTransformer == null ? (class$functologic$game$computer$StandardHeuristicTransformer = StandardHeuristicTransformer.class$("functologic.game.computer.StandardHeuristicTransformer")) : class$functologic$game$computer$StandardHeuristicTransformer).desiredAssertionStatus();
        }
    }
}

