/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import functologic.game.computer.AlphaBetaPruning;
import functologic.game.computer.Field;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.AdversarySearch;
import orbital.logic.functor.Function;
import orbital.util.InnerCheckedException;

public class UtilityComputer
implements Function {
    static final Logger logger;
    private Function utility;
    private int maxDepth;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilityComputer(int n, Function function) {
        this.maxDepth = n;
        this.utility = function;
    }

    public UtilityComputer(int n, String string) throws IOException {
        this.maxDepth = n;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream('/' + string);
            if (inputStream == null) {
                throw new IOException("no such resource /" + string + " for loader of " + this.getClass());
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
            this.utility = (Function)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InnerCheckedException(classNotFoundException);
        }
    }

    public Function getUtility() {
        return this.utility;
    }

    protected void setUtility(Function function) {
        this.utility = function;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
    }

    public Object apply(Object object) {
        Field field = (Field)object;
        String string = field.getTurn() + "";
        logger.log(Level.FINER, "AI {0} action {", new Object[]{string});
        field.setOurLeague(field.getTurn());
        if (!$assertionsDisabled && field.getOurLeague() <= 0) {
            throw new AssertionError((Object)"our league is not just no one");
        }
        AdversarySearch.Option option = this.solve(field);
        if (!$assertionsDisabled && option == null) {
            throw new AssertionError((Object)"computers should evaluate to anything at least");
        }
        field.setOurLeague(0);
        logger.log(Level.FINER, "} AI {0} will perform: {1}", new Object[]{string, option});
        return option;
    }

    protected AdversarySearch.Option solve(Field field) {
        AlphaBetaPruning alphaBetaPruning = new AlphaBetaPruning(this.getMaxDepth(), this.getUtility());
        return alphaBetaPruning.solve(field);
    }

    protected final AdversarySearch.Option solve(orbital.game.Field field) {
        return this.solve((Field)field);
    }

    public String toString() {
        return this.getClass().getName() + "[maxDepth=" + this.maxDepth + ", utility=" + this.utility + "]";
    }

    static {
        $assertionsDisabled = !UtilityComputer.class.desiredAssertionStatus();
        logger = Logger.getLogger(UtilityComputer.class.getName());
    }
}

