/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.io.Serializable;
import java.util.ListIterator;
import orbital.algorithm.GeneralizedPermutation;
import orbital.algorithm.NonrepetitiveCombination;
import orbital.algorithm.NonrepetitivePermutation;
import orbital.algorithm.RepetitiveCombination;
import orbital.algorithm.RepetitivePermutation;

public abstract class Combinatorical
implements Serializable {
    private static final long serialVersionUID = 8581671329920186455L;

    public abstract int count();

    public abstract boolean hasNext();

    public abstract int[] next();

    public abstract boolean hasPrevious();

    public abstract int[] previous();

    public static Combinatorical getInstance(int r, boolean combinations, int n, boolean repetition) {
        return combinations ? Combinatorical.getCombinations(r, n, repetition) : Combinatorical.getPermutations(r, n, repetition);
    }

    public static Combinatorical getPermutations(int r, int n, boolean repetition) {
        return repetition ? new RepetitivePermutation(r, n) : new NonrepetitivePermutation(r, n);
    }

    public static Combinatorical getPermutations(int n, boolean repetition) {
        return Combinatorical.getPermutations(n, n, repetition);
    }

    public static Combinatorical getPermutations(int[] n) {
        return new GeneralizedPermutation(n);
    }

    public static Combinatorical getCombinations(int r, int n, boolean repetition) {
        return repetition ? new RepetitiveCombination(r, n) : new NonrepetitiveCombination(r, n);
    }

    public static final ListIterator asIterator(final Combinatorical c) {
        return new ListIterator(){

            public String toString() {
                return c.toString();
            }

            public Object next() {
                return c.next();
            }

            public boolean hasNext() {
                return c.hasNext();
            }

            public Object previous() {
                return c.previous();
            }

            public boolean hasPrevious() {
                return c.hasPrevious();
            }

            public void add(Object param1) {
                throw new UnsupportedOperationException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object param1) {
                throw new UnsupportedOperationException();
            }

            public int previousIndex() {
                throw new UnsupportedOperationException();
            }

            public int nextIndex() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

