/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.util.NoSuchElementException;
import orbital.algorithm.Combinatorical;
import orbital.math.MathUtilities;

class NonrepetitiveCombination
extends Combinatorical {
    private static final long serialVersionUID = -5852223116797053870L;
    private int r;
    private int n;
    private int[] combination;

    public NonrepetitiveCombination(int r, int n) {
        if (r > n) {
            throw new IllegalArgumentException("only r <= n combinations without repetition exist");
        }
        this.r = r;
        this.n = n;
        this.combination = new int[r];
        for (int i = 0; i < this.combination.length; ++i) {
            this.combination[i] = i;
        }
        int n2 = this.combination.length - 1;
        this.combination[n2] = this.combination[n2] - 1;
    }

    public boolean hasNext() {
        return this.combination[0] < this.n - this.combination.length;
    }

    public int[] next() {
        for (int i = this.combination.length - 1; i >= 0; --i) {
            if (this.combination[i] >= i + this.n - this.combination.length) continue;
            int n = i;
            this.combination[n] = this.combination[n] + 1;
            for (int j = i + 1; j < this.combination.length; ++j) {
                this.combination[j] = this.combination[j - 1] + 1;
            }
            return this.combination;
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int[] previous() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int count() {
        return MathUtilities.nCr(this.n, this.r);
    }

    public String toString() {
        return this.getClass().getName() + "[of " + this.r + " elements out of " + this.n + "]";
    }
}

