/*
 * Decompiled with CFR 0.152.
 */
package orbital.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import orbital.awt.HelperButton;
import orbital.math.MathUtilities;

public class NumberInput
extends Panel {
    private static final long serialVersionUID = -818804052063274016L;
    public static final int TYPING = 0;
    public static final int SLIDER = 1;
    public static final int NUMPAD = 2;
    protected Number nvalue;
    protected int style = 0;
    protected double precision = 1.0;
    protected boolean editable = true;
    protected TextField text;
    private final PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);

    public NumberInput(Number def) {
        this.nvalue = def;
        this.init();
    }

    public NumberInput() {
        this((Number)null);
    }

    public Number getValue() {
        return this.nvalue;
    }

    public void setValue(Number value) {
        this.setValueImpl(value);
        this.text.setText(MathUtilities.format(this.nvalue));
    }

    private void setValueImpl(Number value) {
        Number old = this.nvalue;
        this.nvalue = value;
        this.text.setForeground(this.getForeground());
        this.propertyChangeListeners.firePropertyChange("nvalue", old, this.nvalue);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int st) {
        int old = this.style;
        this.style = st;
        this.propertyChangeListeners.firePropertyChange("style", old, this.style);
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double new_precision) {
        double old = this.precision;
        this.precision = new_precision;
        this.propertyChangeListeners.firePropertyChange("precision", new Double(old), new Double(this.precision));
    }

    public void setEnabled(boolean b) {
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            c[i].setEnabled(b);
        }
        super.setEnabled(b);
    }

    public void addFocusListener(FocusListener l) {
        this.text.addFocusListener(l);
    }

    public void removeFocusListener(FocusListener l) {
        this.text.removeFocusListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.removePropertyChangeListener(l);
    }

    private void init() {
        this.removeAll();
        this.setLayout(new FlowLayout(1, 0, 0));
        this.text = new TextField(this.nvalue == null ? "" : MathUtilities.format(this.nvalue.doubleValue()), 6);
        this.add(this.text);
        this.text.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    NumberInput.this.setValueImpl(Double.valueOf(NumberInput.this.text.getText()));
                }
                catch (NumberFormatException x) {
                    NumberInput.this.text.setForeground(Color.red);
                }
            }
        });
        HelperButton c = new HelperButton("+");
        this.add(c);
        c.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumberInput.this.setValue(new Double(NumberInput.this.getValue().doubleValue() + NumberInput.this.precision));
            }
        });
        c = new HelperButton("-");
        this.add(c);
        c.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NumberInput.this.setValue(new Double(NumberInput.this.getValue().doubleValue() - NumberInput.this.precision));
            }
        });
    }
}

