/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.game.GameRules;
import orbital.robotic.Move;

public abstract class AbstractGameRules
implements GameRules,
Serializable {
    private static final long serialVersionUID = -6507248102358315804L;
    public static final int NOONE = 0;
    public static final int EMPTY = 0;
    protected static final int URL_DETECT = 0;
    protected static final int URL_DOCUMENT_BASE = 1;
    protected static final int URL_RESOURCES = 2;
    private static final int FIGURE_IMAGE_ID = 17;
    private transient Image[][] images;
    private String image_prefix;
    private String image_suffix;
    private int turn = 0;
    private transient int oldTurn = 0;

    protected AbstractGameRules(String prefix, String suffix) {
        this.image_prefix = prefix;
        this.image_suffix = suffix;
        this.images = null;
    }

    protected AbstractGameRules() {
        this("F", ".gif");
    }

    public int getTurn() {
        return this.turn;
    }

    protected void setTurn(int t) {
        this.turn = t;
    }

    public Image getImage(Figure f) {
        int leag = f.getLeague();
        int typ = f.getType();
        if (leag == 0 || typ == 0) {
            leag = 0;
            typ = 0;
        }
        if (this.images == null) {
            throw new IllegalStateException("images have not yet been loaded");
        }
        if (leag < 0 || this.images.length <= leag) {
            throw new IllegalArgumentException("illegal league: " + leag);
        }
        if (typ < 0 || this.images[leag].length <= typ) {
            throw new IllegalArgumentException("illegal type: " + typ);
        }
        return this.images[leag][typ];
    }

    public boolean isNextTurn() {
        if (this.getTurn() != this.oldTurn) {
            this.oldTurn = this.getTurn();
            return true;
        }
        return false;
    }

    protected final int turnDone(Field field) {
        throw new UnsupportedOperationException("deprecated");
    }

    protected void loadAllImages(Component component, int relativeTo) {
        Applet applet = null;
        Toolkit tk = null;
        switch (relativeTo) {
            case 1: {
                applet = (Applet)component;
                break;
            }
            case 2: {
                tk = component.getToolkit();
                break;
            }
            case 0: {
                if (component instanceof Applet) {
                    applet = (Applet)component;
                    break;
                }
                tk = component.getToolkit();
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal relative url type specifier " + relativeTo);
            }
        }
        this.images = new Image[this.getLeagues()][this.getFigureTypes()];
        MediaTracker tracker = component == null ? null : new MediaTracker(component);
        this.images[0][0] = null;
        for (int leag = 1; leag < this.getLeagues(); ++leag) {
            for (int typ = 1; typ < this.getFigureTypes(); ++typ) {
                Image img;
                this.images[leag][typ] = img = this.getImage(applet, tk, this.image_prefix + leag + "_" + typ + this.image_suffix);
                if (tracker == null) continue;
                tracker.addImage(img, 17);
            }
        }
        try {
            tracker.waitForID(17);
        }
        catch (InterruptedException irq) {
            Logger.getLogger(AbstractGameRules.class.getName()).log(Level.WARNING, "initialization had been interrupted", irq);
            Thread.currentThread().interrupt();
        }
    }

    private Image getImage(Applet applet, Toolkit tk, String filename) {
        if (tk != null) {
            return tk.getImage(this.getClass().getResource(filename));
        }
        if (applet != null) {
            return applet.getImage(applet.getDocumentBase(), filename);
        }
        throw new RuntimeException("neither applet nor toolkit is available to get images");
    }

    protected void loadAllImages(Component component) {
        this.loadAllImages(component, 2);
    }

    protected static Move[][] stringToMove(String[][] moveStrings) {
        Move[][] moves = new Move[moveStrings.length][];
        for (int fig = 0; fig < moves.length; ++fig) {
            moves[fig] = new Move[moveStrings[fig].length];
            for (int i = 0; i < moves[fig].length; ++i) {
                moves[fig][i] = new Move(moveStrings[fig][i]);
            }
        }
        return moves;
    }
}

