/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import orbital.game.Field;
import orbital.robotic.Direction;
import orbital.robotic.Move;
import orbital.robotic.Moving;
import orbital.robotic.Position;

public abstract class Figure
extends Moving {
    private static final long serialVersionUID = -3766957702427420203L;
    public static final int NOONE = 0;
    public static final int EMPTY = 0;
    private int league;
    private int type;

    public Figure(int x, int y, Direction dir, int league, int type) {
        super(x, y, dir);
        this.league = league;
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Figure) {
            Figure f = (Figure)obj;
            return super.equals(obj) && this.getLeague() == f.getLeague() && this.getType() == f.getType();
        }
        return false;
    }

    public int hashCode() {
        return this.getLeague() + 17 * this.getType() + 101 * super.hashCode();
    }

    protected void setField(Field f) {
    }

    public int getLeague() {
        return this.league;
    }

    public void setLeague(int l) {
        this.league = l;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public boolean isEmpty() {
        return this.getLeague() == 0 || this.getType() == 0;
    }

    public void setEmpty() {
        this.setLeague(0);
        this.setType(0);
    }

    public abstract Iterator possibleMoves();

    public abstract Position moveFigure(Move var1);

    public abstract Dimension getPreferredSize();

    public abstract void paint(Graphics var1, Rectangle var2);

    public String toString() {
        return this.getClass().getName() + "[" + this.getLeague() + ":" + this.getType() + " @(" + this.x + '|' + this.y + ' ' + this.getDirection().toString() + ")]";
    }
}

