/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import orbital.awt.UIUtilities;
import orbital.game.AwtResourceDecoder;
import orbital.game.Field;
import orbital.game.FieldChangeAdapter;
import orbital.game.FieldChangeEvent;
import orbital.game.Figure;
import orbital.game.FigureImpl;
import orbital.game.GameRules;
import orbital.game.Gameboard;
import orbital.game.Gamemaster;
import orbital.logic.functor.Function;
import orbital.moon.awt.AppletFrame;
import orbital.signe;

public class GameView
extends Applet {
    private static final long serialVersionUID = 1298765184014728813L;
    public static final String usage = "usage: " + GameView.class + " (<parameter>=<value>)*" + System.getProperty("line.separator") + "\tThe game applet has access to the values assigned to the parameters.";
    private ResourceBundle resources;
    private static final String FILE_IDENTIFIER = "Game";
    private String gameName = null;
    private Gamemaster gamemaster;
    private Gameboard board;
    private Container control = null;
    private Label nameLabel;
    private final Dictionary actions = new Hashtable();
    private volatile Thread runner = null;

    public static void main(String[] arg) throws Exception {
        if (arg.length == 0 || signe.isHelpRequest(arg)) {
            System.out.println(usage);
            System.out.println(AppletFrame.info(new GameView()));
            return;
        }
        AppletFrame.showApplet(new GameView(), "Game Application", arg);
    }

    public GameView() {
        this.actions.put("new", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GameView.this.stop();
                GameView.this.start();
            }
        });
        this.actions.put("load", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog dlg = new FileDialog(UIUtilities.getParentalFrame(GameView.this), GameView.this.getResources().getString("dialog.game.load.title"), 0);
                dlg.setVisible(true);
                String file = dlg.getFile();
                if (file == null) {
                    return;
                }
                File f = new File(dlg.getDirectory(), file);
                if (f.exists()) {
                    try {
                        ObjectInputStream is = new ObjectInputStream(new FileInputStream(f));
                        GameView.this.load(is);
                        is.close();
                        GameView.this.showStatus(GameView.this.getResources().getString("statusbar.game.load"));
                    }
                    catch (IOException x) {
                        GameView.this.log(x);
                    }
                    catch (ClassNotFoundException x) {
                        GameView.this.log(x);
                    }
                }
            }
        });
        this.actions.put("save", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileDialog dlg = new FileDialog(UIUtilities.getParentalFrame(GameView.this), GameView.this.getResources().getString("dialog.game.save.title"), 1);
                dlg.setVisible(true);
                String file = dlg.getFile();
                if (file == null) {
                    return;
                }
                File f = new File(dlg.getDirectory(), file);
                try {
                    ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
                    GameView.this.store(os);
                    os.close();
                    GameView.this.showStatus(GameView.this.getResources().getString("statusbar.game.save"));
                }
                catch (IOException x) {
                    GameView.this.log(x);
                }
            }
        });
        this.actions.put("stop", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GameView.this.stop();
            }
        });
    }

    public String getGameName() {
        return this.gameName;
    }

    protected void setGameName(String newName) {
        this.gameName = newName;
    }

    public Gamemaster getGamemaster() {
        return this.gamemaster;
    }

    protected void setGamemaster(Gamemaster newMaster) {
        this.gamemaster = newMaster;
    }

    public GameRules getGameRules() {
        return this.getGamemaster().getGameRules();
    }

    protected void setGameRules(GameRules newRules) {
        this.getGamemaster().setGameRules(newRules);
    }

    public Function[] getPlayers() {
        return this.getGamemaster().getPlayers();
    }

    public Gameboard getGameboard() {
        return this.board;
    }

    private void setGameboard(Gameboard newGameboard) {
        this.board = newGameboard;
    }

    protected Container getControl() {
        return this.control;
    }

    protected ResourceBundle getResources() {
        if (this.resources == null) {
            try {
                this.resources = ResourceBundle.getBundle(this.getClass().getName(), Locale.getDefault(), this.getClass().getClassLoader());
                return this.resources;
            }
            catch (Exception trial) {
                System.out.println("no resources specified for: " + this.getClass().getName() + "\nUsing default resources\n" + trial);
                try {
                    this.resources = ResourceBundle.getBundle(GameView.class.getName());
                    return this.resources;
                }
                catch (MissingResourceException missing) {
                    this.log("missing resource: An error occured initializing " + GameView.class.getName() + ".\nThe package seems corrupt or a resource is missing, aborting\n" + missing);
                    throw (MissingResourceException)new MissingResourceException(trial.getMessage() + " AND " + missing.getMessage(), missing.getClassName(), missing.getKey()).initCause(missing);
                }
            }
        }
        return this.resources;
    }

    protected final Dictionary getActions() {
        return this.actions;
    }

    protected void setField(Field field) {
        this.board.setField(field);
        field.addFieldChangeListener(new FieldChangeAdapter(){

            public void stateChanged(FieldChangeEvent evt) {
                if (evt.getType() == 33) {
                    GameView.this.displayWinner((Integer)evt.getChangeInfo());
                }
            }
        });
    }

    public void init() {
        super.init();
        String param = this.getParameter("gameName");
        this.setGameName(param == null ? "Generic Game" : param);
        param = this.getParameter("gameRules");
        String gameRules = param == null ? "YourGameRules" : param;
        try {
            GameRules rules = this.createGameRules(gameRules);
            Function[] players = new Function[rules.getLeagues()];
            for (int i = 0; i < players.length; ++i) {
                String arg = this.getParameter("player-" + i);
                players[i] = arg == null || arg.equals("null") ? null : rules.startAIntelligence(i, arg);
            }
            this.setGamemaster(new Gamemaster(this, rules, players));
        }
        catch (Exception e) {
            this.log(e);
        }
        GameView pane = this;
        pane.setLayout(new BorderLayout());
        if (this.control == null) {
            this.control = this.createControl();
            pane.add((Component)this.control, "North");
            this.setGameboard(new Gameboard());
            pane.add((Component)this.board, "Center");
            MenuBar ourBar = this.createMenuBar();
            if (ourBar != null) {
                try {
                    Frame parent = UIUtilities.getParentalFrame(this);
                    if (parent != null) {
                        MenuBar bar = parent.getMenuBar();
                        if (bar == null) {
                            bar = new MenuBar();
                            parent.setMenuBar(bar);
                        }
                        for (int i = 0; i < ourBar.getMenuCount(); ++i) {
                            bar.add(ourBar.getMenu(i));
                        }
                    }
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
        }
        this.showStatus(this.getResources().getString("statusbar.game.init"));
    }

    public void start() {
        this.start(null);
    }

    private void start(Field initialField) {
        this.setGamemaster(new Gamemaster(this, this.getGamemaster().getGameRules(), this.getGamemaster().getPlayers(), initialField));
        this.getGamemaster().start();
        this.setField(this.getGamemaster().getField());
        this.showStatus(this.getResources().getString("statusbar.game.start"));
    }

    public void stop() {
        this.getGamemaster().stop();
        this.showStatus(this.getResources().getString("statusbar.game.stop"));
    }

    public void destroy() {
        this.getGamemaster().destroy();
        this.setGamemaster(null);
        this.removeAll();
        this.control = null;
        this.resources = null;
        super.destroy();
    }

    protected Container createControl() {
        Panel control = new Panel();
        control.setLayout(new BorderLayout());
        this.nameLabel = new Label(this.gameName, 1);
        control.add((Component)this.nameLabel, "North");
        final PopupMenu pop = this.createPopupMenu();
        if (pop != null) {
            control.add(pop);
            MouseAdapter popper = new MouseAdapter(){

                public void mouseClicked(MouseEvent ms) {
                    pop.show(ms.getComponent(), ms.getX(), ms.getY());
                }
            };
            control.addMouseListener(popper);
            this.nameLabel.add(pop);
            this.nameLabel.addMouseListener(popper);
        }
        return control;
    }

    private MenuBar createMenuBar() {
        return new AwtResourceDecoder(this.getResources(), this.actions).createMenuBar();
    }

    private PopupMenu createPopupMenu() {
        return new AwtResourceDecoder(this.getResources(), this.actions).createPopupMenu();
    }

    protected void displayWinner(int league) {
        this.showStatus(this.getResources().getString("statusbar.game.end"));
        ResourceBundle resources = this.getResources();
        String winner = (this.getPlayers()[Math.abs(league)] == null ? resources.getString("text.player") : resources.getString("text.computer")) + " (" + Math.abs(league) + ')';
        int selected = JOptionPane.showConfirmDialog(UIUtilities.getParentalFrame(this), winner + ' ' + resources.getString("dialog.game.finish.hasWon") + (league > 0 ? resources.getString("dialog.game.finish.won") : resources.getString("dialog.game.finish.survived")) + resources.getString("dialog.game.finish.tryAgain"), resources.getString("dialog.game.finish.title"), 1, 3);
        if (selected == 0) {
            this.stop();
            this.start();
        } else {
            this.repaint();
        }
    }

    public void load(ObjectInputStream is) throws ClassNotFoundException, IOException {
        this.stop();
        if (!FILE_IDENTIFIER.equals(is.readUTF())) {
            throw new IOException("illegal format of stream content");
        }
        Field field = (Field)is.readObject();
        this.start(field);
        Iterator i = field.iterateNonEmpty();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            if (!(f instanceof FigureImpl)) continue;
            ((FigureImpl)f).setImage(this.getGameRules().getImage(f));
        }
    }

    public void store(ObjectOutputStream os) throws IOException {
        os.writeUTF(FILE_IDENTIFIER);
        os.writeObject(this.board.getField());
    }

    protected GameRules createGameRules(String gameRules) throws Exception {
        return (GameRules)GameView.instantiate(gameRules);
    }

    protected GameRules getGameRules(String gameRules) throws Exception {
        return this.createGameRules(gameRules);
    }

    private static final Object instantiate(String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            return Class.forName(className, true, cl).newInstance();
        }
        catch (ClassNotFoundException ex) {
            cl = GameView.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            return Class.forName(className, true, cl).newInstance();
        }
    }

    public void paint(Graphics g) {
        this.paintComponents(g);
    }

    private void log(Object msg) {
        this.showStatus(msg + "");
        if (msg instanceof Throwable) {
            ((Throwable)msg).printStackTrace();
        }
    }

    public String getAppletInfo() {
        return "Generic Java applet displaying strategic board games. Copyright " + signe.getCreated() + " by " + signe.getCreator();
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"gameName", "String", "name of the specific game"}, {"gameRules", "String", "parameter describing the GameRules. Per default this is the name of a class that implements " + GameRules.class}, {"player-X", "String", "the argument to pass when starting player number X. If left out, a human player will play X."}};
        return info;
    }
}

