/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Component;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.game.FieldChangeAdapter;
import orbital.game.FieldChangeEvent;
import orbital.game.FieldChangeListener;
import orbital.game.GameRules;
import orbital.logic.functor.Function;
import orbital.robotic.Position;

public class Gamemaster
implements Runnable {
    private GameRules rules;
    private Function[] players;
    private final transient Component component;
    private Field field;
    private HumanPlayer humanPlayer = null;
    private FieldChangeListener endOfGameListener = new FieldChangeAdapter(){

        public void stateChanged(FieldChangeEvent evt) {
            if (evt.getType() == 33) {
                Gamemaster.this.stop();
            }
        }
    };
    private volatile Thread runner = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Gamemaster(Component component, GameRules rules, Function[] players, Field initialField) {
        if (players.length != rules.getLeagues()) {
            throw new IllegalArgumentException("Illegal number of players, expected: " + rules.getLeagues() + " found: " + players.length);
        }
        this.component = component;
        this.setGameRules(rules);
        this.setField(initialField);
        this.setPlayers(players);
    }

    public Gamemaster(Component component, GameRules rules, Function[] players) {
        this(component, rules, players, null);
    }

    public GameRules getGameRules() {
        return this.rules;
    }

    protected void setGameRules(GameRules newRules) {
        this.rules = newRules;
    }

    public Function[] getPlayers() {
        Function[] players = this.getPlayersInternal();
        Function[] c = new Function[players.length];
        for (int i = 1; i < players.length; ++i) {
            c[i] = players[i] instanceof HumanPlayer ? null : players[i];
        }
        return c;
    }

    private void setPlayers(Function[] newPlayers) {
        if (!$assertionsDisabled && newPlayers[0] != null) {
            throw new AssertionError((Object)"0 needs no player, so you can safely set it to null");
        }
        Function[] players = new Function[newPlayers.length];
        for (int i = 1; i < players.length; ++i) {
            Function function;
            if (newPlayers[i] != null) {
                function = newPlayers[i];
            } else {
                this.humanPlayer = this.humanPlayer != null ? this.humanPlayer : new HumanPlayer();
                function = this.humanPlayer;
            }
            players[i] = function;
        }
        this.setPlayersInternal(players);
    }

    protected Function[] getPlayersInternal() {
        return this.players;
    }

    private void setPlayersInternal(Function[] newPlayers) {
        if (!$assertionsDisabled && newPlayers[0] != null) {
            throw new AssertionError((Object)"0 needs no player, so you can safely set it to null");
        }
        this.players = newPlayers;
    }

    public int getPlayersCount() {
        return this.getPlayersInternal().length;
    }

    public int getNumberOfHumanPlayers() {
        Function[] players = this.getPlayersInternal();
        int count = 0;
        for (int i = 1; i < players.length; ++i) {
            if (!(players[i] instanceof HumanPlayer)) continue;
            ++count;
        }
        return count;
    }

    public Field getField() {
        return this.field;
    }

    protected final void setField(Field newField) {
        this.field = newField;
    }

    protected final Thread getRunner() {
        return this.runner;
    }

    public void showStatus(String msg) {
        System.out.println(msg);
    }

    public void start() {
        if (this.getField() == null) {
            this.setField(this.rules.startField(this.component));
        }
        this.getField().addFieldChangeListener(this.endOfGameListener);
        if (this.humanPlayer != null) {
            this.getField().addFieldChangeListener(this.humanPlayer);
        }
        this.runner = new Thread((Runnable)this, "Gamemaster");
        this.runner.start();
    }

    public void stop() {
        Field field;
        Thread moribund = this.runner;
        this.runner = null;
        if (moribund != null) {
            moribund.interrupt();
        }
        if ((field = this.getField()) != null) {
            field.removeFieldChangeListener(this.endOfGameListener);
            if (this.humanPlayer != null) {
                field.removeFieldChangeListener(this.humanPlayer);
            }
        }
    }

    public void destroy() {
        this.setGameRules(null);
        this.setField(null);
        this.players = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.playGame();
        }
        finally {
            this.setField(null);
        }
    }

    private final void playGame() {
        Thread thisThread = Thread.currentThread();
        Field field = this.getField();
        if (field == null) {
            throw new IllegalStateException("illegal field for starting the game: " + field);
        }
        field.getFieldChangeMulticaster().stateChanged(new FieldChangeEvent(field, 32, null));
        while (this.runner == thisThread && !Thread.interrupted()) {
            field = this.getField();
            if (field == null) {
                throw new IllegalStateException("illegal field: " + field);
            }
            int turn = field.getTurn();
            this.showStatus("statusbar.ai.thinking " + turn + " " + this.players[turn]);
            if (!(this.players[turn] instanceof HumanPlayer)) {
                System.err.println("statusbar.ai.thinking");
            }
            Object action = this.players[turn].apply(this.getField());
            this.showStatus("statusbar.ai.decided " + turn + " " + this.players[turn]);
            if (action instanceof AdversarySearch.Option) {
                AdversarySearch.Option move = (AdversarySearch.Option)action;
                if (move.isNoMove()) {
                    this.showStatus("statusbar.ai.notmoving " + turn + " " + this.players[turn]);
                    continue;
                }
                this.showStatus("statusbar.ai.moving " + turn + " " + this.players[turn]);
                Position source = new Position(move.getFigure());
                if (field.move(source, move.getMove())) continue;
                throw new Error("player " + this.players[turn] + " for league " + turn + " should only take legal moves: " + move);
            }
            throw new Error("player " + this.players[turn] + " for league " + turn + " found no move: " + action);
        }
    }

    static {
        $assertionsDisabled = !Gamemaster.class.desiredAssertionStatus();
    }

    private class HumanPlayer
    extends FieldChangeAdapter
    implements Function {
        private volatile AdversarySearch.Option option;
        private final Object userAction = new Object(this){
            private final /* synthetic */ HumanPlayer this$1;
            {
                this.this$1 = this$1;
            }
        };
        static final /* synthetic */ boolean $assertionsDisabled;

        private HumanPlayer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object apply(Object field) {
            try {
                AdversarySearch.Option userOption;
                Object object = this.userAction;
                synchronized (object) {
                    if (this.option == null) {
                        this.userAction.wait();
                    }
                    userOption = this.option;
                    this.option = null;
                }
                return userOption;
            }
            catch (InterruptedException interrupt) {
                Thread r = Gamemaster.this.runner;
                Gamemaster.this.stop();
                if (r != null) {
                    r.interrupt();
                }
                Thread.currentThread().interrupt();
                throw new InternalError("OutOfCheeseError");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void movePerformed(FieldChangeEvent evt) {
            if (!$assertionsDisabled && evt.getField() != Gamemaster.this.getField()) {
                throw new AssertionError((Object)("we have only registered ourselves to our field " + Gamemaster.this.getField() + " source=" + evt.getField()));
            }
            if ((evt.getType() & 0x1002) == 4098) {
                Object object = this.userAction;
                synchronized (object) {
                    this.option = (AdversarySearch.Option)evt.getChangeInfo();
                    this.userAction.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(FieldChangeEvent evt) {
            if (!$assertionsDisabled && evt.getField() != Gamemaster.this.getField()) {
                throw new AssertionError((Object)("we have only registered ourselves to our field " + Gamemaster.this.getField() + " source=" + evt.getField()));
            }
            if ((evt.getType() & 0x1010) == 4112) {
                Object object = this.userAction;
                synchronized (object) {
                    this.option = AdversarySearch.Option.createNoMove(evt.getField());
                    if (!$assertionsDisabled && !this.option.isNoMove()) {
                        throw new AssertionError();
                    }
                    this.userAction.notify();
                }
            }
        }

        static {
            $assertionsDisabled = !(class$orbital$game$Gamemaster == null ? (class$orbital$game$Gamemaster = Gamemaster.class$("orbital.game.Gamemaster")) : class$orbital$game$Gamemaster).desiredAssertionStatus();
        }
    }
}

