/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import java.util.Iterator;
import java.util.NoSuchElementException;
import orbital.util.QueuedIterator;

class ParallelIterator
extends QueuedIterator {
    private static final long serialVersionUID = -7678775639316739430L;
    protected final Iterator backing;
    protected final ParallelIterator parallel;

    public ParallelIterator(Iterator backing) {
        this.backing = backing;
        this.parallel = new ParallelIterator(backing, this);
    }

    private ParallelIterator(Iterator backing, ParallelIterator parallel) {
        this.backing = backing;
        this.parallel = parallel;
    }

    public Iterator getParallel() {
        return this.parallel;
    }

    public boolean hasNext() {
        return super.hasNext() || this.backing.hasNext();
    }

    public Object next() {
        try {
            return super.next();
        }
        catch (NoSuchElementException x) {
            Object o = this.backing.next();
            this.parallel.add(o);
            return o;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

