/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

class GetPropertyAction
implements PrivilegedAction {
    private final String propertyName;
    private final String defaultValue;

    public static final String getProperty(String propertyName, String defaultValue) {
        try {
            return (String)AccessController.doPrivileged(new GetPropertyAction(propertyName, defaultValue));
        }
        catch (AccessControlException denied) {
            return defaultValue;
        }
    }

    public GetPropertyAction(String propertyName, String defaultValue) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
    }

    public Object run() {
        return System.getProperty(this.propertyName, this.defaultValue);
    }
}

