/*
 * Decompiled with CFR 0.152.
 */
package orbital.math.functional;

import orbital.logic.sign.concrete.Notation;
import orbital.math.Arithmetic;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.AbstractBinaryFunction;
import orbital.math.functional.AbstractFunction;
import orbital.math.functional.BinaryFunction;
import orbital.math.functional.Function;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.PackageUtilities;
import orbital.util.Utility;

public interface Operations {
    public static final BinaryFunction plus = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            Arithmetic[] operands = (Arithmetic[])PackageUtilities.valueFactory.getCoercer().apply(new Arithmetic[]{(Arithmetic)x, (Arithmetic)y});
            return operands[0].add(operands[1]);
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functions.binaryone, Functions.binaryone}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return (BinaryFunction)plus.apply(times.apply(Functions.projectFirst, Functions.projectSecond), divide.apply(Functionals.on(i, Functions.square), Values.getDefaultInstance().valueOf(2)));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "+";
        }
    };
    public static final Function sum = new AbstractFunction(){

        public Object apply(Object a) {
            return Functionals.foldLeft((orbital.logic.functor.BinaryFunction)plus, (Object)Values.ZERO, Utility.asIterator(a));
        }

        public Function derive() {
            throw new ArithmeticException(this + " is only partially derivable");
        }

        public Function integrate() {
            throw new ArithmeticException(this + " is only (undefinitely) integrable with respect to a single variable");
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "\u2211";
        }
    };
    public static final Function minus = new AbstractFunction(){

        public Object apply(Object x) {
            return ((Arithmetic)x).minus();
        }

        public Function derive() {
            return Functions.constant(Values.MINUS_ONE);
        }

        public Function integrate() {
            return (Function)minus.apply(divide.apply(Functions.square, Values.getDefaultInstance().valueOf(2)));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "-";
        }
    };
    public static final BinaryFunction subtract = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            Arithmetic[] operands = (Arithmetic[])PackageUtilities.valueFactory.getCoercer().apply(new Arithmetic[]{(Arithmetic)x, (Arithmetic)y});
            return operands[0].subtract(operands[1]);
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functions.binaryConstant(Values.getDefaultInstance().valueOf(1)), Functions.binaryConstant(Values.MINUS_ONE)}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? (BinaryFunction)subtract.apply(divide.apply(Functionals.onFirst(Functions.square), Values.getDefaultInstance().valueOf(2)), times.apply(Functions.projectFirst, Functions.projectSecond)) : (BinaryFunction)subtract.apply(times.apply(Functions.projectFirst, Functions.projectSecond), divide.apply(Functionals.onSecond(Functions.square), Values.getDefaultInstance().valueOf(2)));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "-";
        }
    };
    public static final BinaryFunction times = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            Arithmetic[] operands = (Arithmetic[])PackageUtilities.valueFactory.getCoercer().apply(new Arithmetic[]{(Arithmetic)x, (Arithmetic)y});
            return operands[0].multiply(operands[1]);
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functions.projectSecond, Functions.projectFirst}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? (BinaryFunction)divide.apply(times.apply(Functionals.onFirst(Functions.square), Functions.projectSecond), Values.getDefaultInstance().valueOf(2)) : (BinaryFunction)divide.apply(times.apply(Functions.projectFirst, Functionals.onSecond(Functions.square)), Values.getDefaultInstance().valueOf(2));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "*";
        }
    };
    public static final Function product = new AbstractFunction(){

        public Object apply(Object a) {
            return Functionals.foldLeft((orbital.logic.functor.BinaryFunction)times, (Object)Values.ONE, Utility.asIterator(a));
        }

        public Function derive() {
            throw new ArithmeticException(this + " is only partially derivable");
        }

        public Function integrate() {
            throw new ArithmeticException(this + " is only (undefinitely) integrable with respect to a single variable");
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "\u220f";
        }
    };
    public static final Function inverse = new AbstractFunction(){

        public Object apply(Object x) {
            return ((Arithmetic)x).inverse();
        }

        public Function derive() {
            return Functionals.compose(minus, Functions.pow(Values.getDefaultInstance().valueOf(-2)));
        }

        public Function integrate() {
            return Functions.log;
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "^-1";
        }
    };
    public static final BinaryFunction divide = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            Arithmetic[] operands = (Arithmetic[])PackageUtilities.valueFactory.getCoercer().apply(new Arithmetic[]{(Arithmetic)x, (Arithmetic)y});
            return operands[0].divide(operands[1]);
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functionals.onSecond(Functions.reciprocal), Functionals.compose(divide, Functionals.onFirst(minus), Functionals.onSecond(Functions.square))}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? (BinaryFunction)divide.apply(divide.apply(Functionals.onFirst(Functions.square), Functions.projectSecond), Values.getDefaultInstance().valueOf(2)) : (BinaryFunction)times.apply(Functionals.onSecond(Functions.log), Functions.projectFirst);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "/";
        }
    };
    public static final BinaryFunction power = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            Arithmetic[] operands = (Arithmetic[])PackageUtilities.valueFactory.getCoercer().apply(new Arithmetic[]{(Arithmetic)x, (Arithmetic)y});
            return operands[0].power(operands[1]);
        }

        public BinaryFunction derive() {
            return (BinaryFunction)((Object)Functionals.genericCompose(new BinaryFunction[][]{{Functionals.compose(times, Functions.projectSecond, Functionals.compose(power, Functions.projectFirst, Functionals.compose(subtract, Functions.projectSecond, Functions.binaryone))), Functionals.compose(times, Functionals.onFirst(Functions.log), power)}}));
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            return i == 0 ? (BinaryFunction)divide.apply(power.apply(Functions.projectFirst, plus.apply(Functions.projectSecond, Values.getDefaultInstance().valueOf(1))), plus.apply(Functions.projectSecond, Values.getDefaultInstance().valueOf(1))) : (BinaryFunction)divide.apply(power, Functionals.onFirst(Functions.log));
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "^";
        }
    };
    public static final BinaryFunction min = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            if (x instanceof Comparable && y instanceof Comparable) {
                return ((Comparable)x).compareTo(y) <= 0 ? x : y;
            }
            return Functionals.genericCompose(min, x, y);
        }

        public BinaryFunction derive() {
            throw new UnsupportedOperationException(this + "'");
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "min";
        }
    };
    public static final Function inf = new AbstractFunction(){

        public Object apply(Object a) {
            return Functionals.foldLeft((orbital.logic.functor.BinaryFunction)min, (Object)Values.POSITIVE_INFINITY, Utility.asIterator(a));
        }

        public Function derive() {
            throw new UnsupportedOperationException(this + "'");
        }

        public Function integrate() {
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "\u2293";
        }
    };
    public static final BinaryFunction max = new AbstractBinaryFunction(){

        public Object apply(Object x, Object y) {
            if (x instanceof Comparable && y instanceof Comparable) {
                return ((Comparable)x).compareTo(y) >= 0 ? x : y;
            }
            return Functionals.genericCompose(max, x, y);
        }

        public BinaryFunction derive() {
            throw new UnsupportedOperationException(this + "'");
        }

        public BinaryFunction integrate(int i) {
            Utility.pre(0 <= i && i <= 1, "binary integral");
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "max";
        }
    };
    public static final Function sup = new AbstractFunction(){

        public Object apply(Object a) {
            return Functionals.foldLeft((orbital.logic.functor.BinaryFunction)max, (Object)Values.NEGATIVE_INFINITY, Utility.asIterator(a));
        }

        public Function derive() {
            throw new UnsupportedOperationException(this + "'");
        }

        public Function integrate() {
            throw new UnsupportedOperationException("integrate " + this);
        }

        public Real norm() {
            return Values.POSITIVE_INFINITY;
        }

        public String toString() {
            return "\u2294";
        }
    };
    public static final Operations operations = new Operations(){
        private final short dummy = this.initialize();

        private final short initialize() {
            Notation.setAllNotations(new Object[][]{{inverse, new Notation.NotationSpecification(195, "xf", Notation.POSTFIX)}, {power, new Notation.NotationSpecification(200, "xfy", Notation.INFIX)}, {times, new Notation.NotationSpecification(400, "yfx", Notation.INFIX)}, {divide, new Notation.NotationSpecification(400, "yfx", Notation.INFIX)}, {minus, new Notation.NotationSpecification(500, "fx", Notation.PREFIX)}, {plus, new Notation.NotationSpecification(500, "yfx", Notation.INFIX)}, {subtract, new Notation.NotationSpecification(500, "yfx", Notation.INFIX)}});
            return Short.MIN_VALUE;
        }
    };
}

