/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Dimension;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Complex;
import orbital.math.Integer;
import orbital.math.LUDecomposition;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractTensor;
import orbital.moon.math.AbstractVector;
import orbital.moon.math.ArithmeticMatrix;
import orbital.moon.math.ArithmeticVector;
import orbital.moon.math.ValuesImpl;
import orbital.util.Utility;

public abstract class AbstractMatrix
extends AbstractTensor
implements Matrix {
    private static final Logger logger;
    private static final long serialVersionUID = 1360625645424730123L;
    protected transient int modCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract Matrix newInstance(Dimension var1);

    protected final Matrix newInstance(int height, int width) {
        return this.newInstance(new Dimension(width, height));
    }

    protected final Tensor newInstance(int[] dim) {
        return dim.length == 2 ? this.newInstance(dim[0], dim[1]) : Values.getDefaultInstance().newInstance(dim);
    }

    public double getDoubleValue(int i, int j) {
        try {
            return ((Number)((Object)this.get(i, j))).doubleValue();
        }
        catch (ClassCastException x) {
            throw new UnsupportedOperationException("no real number");
        }
    }

    public ListIterator getColumns() {
        return new ListIterator(){
            private int cursor = 0;
            private int lastRet = -1;
            private transient int expectedModCount;
            {
                this.expectedModCount = AbstractMatrix.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor < AbstractMatrix.this.dimension().width;
            }

            public boolean hasPrevious() {
                return this.cursor != 0;
            }

            public Object next() {
                try {
                    Vector next = AbstractMatrix.this.getColumn(this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor++;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public Object previous() {
                try {
                    Vector previous = AbstractMatrix.this.getColumn(--this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor;
                    return previous;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.removeColumn(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void set(Object o) {
                if (!(o instanceof Vector)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.setColumn(this.lastRet, (Vector)o);
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void add(Object o) {
                if (!(o instanceof Matrix)) {
                    throw new IllegalArgumentException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.insertColumns(this.cursor++, (Matrix)o);
                    this.lastRet = -1;
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            private final void checkForComodification() {
                if (AbstractMatrix.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public ListIterator getRows() {
        return new ListIterator(){
            private int cursor = 0;
            private int lastRet = -1;
            private transient int expectedModCount;
            {
                this.expectedModCount = AbstractMatrix.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor < AbstractMatrix.this.dimension().height;
            }

            public boolean hasPrevious() {
                return this.cursor > 0;
            }

            public Object next() {
                try {
                    Vector next = AbstractMatrix.this.getRow(this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor++;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public Object previous() {
                try {
                    Vector previous = AbstractMatrix.this.getRow(--this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor;
                    return previous;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.removeRow(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void set(Object o) {
                if (!(o instanceof Vector)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.setRow(this.lastRet, (Vector)o);
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void add(Object o) {
                if (!(o instanceof Matrix)) {
                    throw new IllegalArgumentException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.insertRows(this.cursor++, (Matrix)o);
                    this.lastRet = -1;
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            private final void checkForComodification() {
                if (AbstractMatrix.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public ListIterator iterator() {
        return new ListIterator(){
            private int i = 0;
            private int j = 0;
            private int lastRetI = -1;
            private int lastRetJ = -1;
            private transient int expectedModCount;
            static final /* synthetic */ boolean $assertionsDisabled;
            {
                this.expectedModCount = AbstractMatrix.this.modCount;
            }

            public boolean hasNext() {
                return this.i < AbstractMatrix.this.dimension().height && this.j < AbstractMatrix.this.dimension().width;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Arithmetic v = AbstractMatrix.this.get(this.i, this.j);
                this.checkForComodification();
                this.lastRetI = this.i++;
                this.lastRetJ = this.j++;
                if (this.j >= AbstractMatrix.this.dimension().width) {
                    this.j = 0;
                }
                return v;
            }

            public boolean hasPrevious() {
                return this.i > 0 || this.j > 0;
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                if (--this.j < 0) {
                    this.j = AbstractMatrix.this.dimension().width - 1;
                    --this.i;
                }
                Arithmetic v = AbstractMatrix.this.get(this.i, this.j);
                this.checkForComodification();
                this.lastRetI = this.i;
                this.lastRetJ = this.j;
                return v;
            }

            public void set(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                if (!$assertionsDisabled && this.lastRetI == -1 != (this.lastRetJ == -1)) {
                    throw new AssertionError((Object)"initialization (or remove, or add) resets both variables");
                }
                if (this.lastRetI == -1 && this.lastRetJ == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractMatrix.this.set(this.lastRetI, this.lastRetJ, (Arithmetic)o);
                    this.expectedModCount = AbstractMatrix.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public int nextIndex() {
                throw new UnsupportedOperationException("a matrix does not have a one-dimensional index");
            }

            public int previousIndex() {
                throw new UnsupportedOperationException("a matrix does not have a one-dimensional index");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("adding a single element to a matrix is impossible");
            }

            public void remove() {
                throw new UnsupportedOperationException("removing a single element from a matrix is impossible");
            }

            private final void checkForComodification() {
                if (AbstractMatrix.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }

            static {
                $assertionsDisabled = !(class$orbital$moon$math$AbstractMatrix == null ? (class$orbital$moon$math$AbstractMatrix = AbstractMatrix.class$("orbital.moon.math.AbstractMatrix")) : class$orbital$moon$math$AbstractMatrix).desiredAssertionStatus();
            }
        };
    }

    public Vector getColumn(int c) {
        return new ColumnVector(this, c);
    }

    public void setColumn(int c, Vector col) throws UnsupportedOperationException {
        this.validate(col.dimension() - 1, c);
        Utility.pre(col.dimension() == this.dimension().height, "column vector and Matrix need compatible height (" + col.dimension() + "!=" + this.dimension().height + ")");
        for (int i = 0; i < col.dimension(); ++i) {
            this.set(i, c, col.get(i));
        }
    }

    public Vector getRow(int r) {
        return new RowVector(this, r);
    }

    public void setRow(int r, Vector row) throws UnsupportedOperationException {
        this.validate(r, row.dimension() - 1);
        Utility.pre(row.dimension() == this.dimension().width, "row vector and Matrix need compatible width (" + row.dimension() + "!=" + this.dimension().width + ")");
        for (int j = 0; j < row.dimension(); ++j) {
            this.set(r, j, row.get(j));
        }
    }

    protected abstract void set(Arithmetic[][] var1);

    public Matrix subMatrix(int i1, int i2, int j1, int j2) {
        return new SubMatrix(this, i1, i2, j1, j2);
    }

    public Vector getDiagonal() {
        if (!this.isSquare()) {
            throw new ArithmeticException("Only square matrices have a diagonal vector");
        }
        Vector diagon = (Vector)this.newInstance(new int[]{this.dimension().height});
        for (int i = 0; i < diagon.dimension(); ++i) {
            diagon.set(i, this.get(i, i));
        }
        return diagon;
    }

    public boolean isSquare() {
        return this.dimension().width == this.dimension().height;
    }

    public boolean isSymmetric() throws ArithmeticException {
        if (!this.isSquare()) {
            throw new ArithmeticException("Only square matrices can be symmetric");
        }
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = i + 1; j < this.dimension().width; ++j) {
                if (this.get(i, j).equals(this.get(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    public int isDefinite() throws ArithmeticException {
        if (!this.isSquare()) {
            throw new ArithmeticException("Only square matrices can be positive, negative or indefinite");
        }
        int sign = -MathUtilities.sign(Values.ZERO.compareTo(this.get(0, 0)));
        if (sign == 0) {
            throw new UnsupportedOperationException("only the test for positive definite and negative definite has been implemented yet");
        }
        for (int i = 1; i < this.dimension().height; ++i) {
            int s = -MathUtilities.sign(Values.ZERO.compareTo(this.subMatrix(0, i, 0, i).det()));
            if (s == sign) continue;
            throw new UnsupportedOperationException("only the test for positive definite and negative definite has been implemented yet");
        }
        return sign;
    }

    public boolean isInvertible() throws ArithmeticException {
        return !this.det().norm().equals(Values.ZERO);
    }

    public boolean isRegular() throws ArithmeticException {
        return this.isInvertible();
    }

    public int linearRank() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("linear rank not yet implemented for non-square matrices. Append 0s");
        }
        return LUDecomposition.decompose(this).linearRank();
    }

    public void swapColumns(int a, int b) {
        if (a == b) {
            return;
        }
        Vector v = this.getColumn(a);
        this.setColumn(a, this.getColumn(b));
        this.setColumn(b, v);
    }

    public void swapRows(int a, int b) {
        if (a == b) {
            return;
        }
        Vector v = this.getRow(a);
        this.setRow(a, this.getRow(b));
        this.setRow(b, v);
    }

    public Real norm() {
        return (Real)Functions.sqrt.apply(Operations.sum.apply(Functionals.map((Function)Functions.square, Functionals.map((Function)Functions.norm, this.iterator()))));
    }

    public Real norm(double p) {
        Utility.pre(p >= 1.0, "p-norm defined for p>=1");
        Function sumOfNorms = new Function(){

            public Object apply(Object v) {
                return Operations.sum.apply(Functionals.map(Functions.norm, (Vector)v));
            }
        };
        if (p == Double.POSITIVE_INFINITY) {
            return (Real)Operations.sup.apply(Functionals.map(sumOfNorms, this.getRows()));
        }
        if (p == 1.0) {
            return (Real)Operations.sup.apply(Functionals.map(sumOfNorms, this.getColumns()));
        }
        if (p == 2.0) {
            throw new UnsupportedOperationException("Spectral norm not yet implemented");
        }
        throw new UnsupportedOperationException("only 1, 2 and infinity norms are provided");
    }

    public Arithmetic trace() throws ArithmeticException {
        if (!this.isSquare()) {
            throw new ArithmeticException("trace only defined for square matrices");
        }
        return (Arithmetic)Operations.sum.apply(this.getDiagonal());
    }

    public Arithmetic det() throws ArithmeticException {
        if (!this.isSquare()) {
            throw new ArithmeticException("determinant only defined for square matrices");
        }
        if (this.dimension().width == 1) {
            return this.get(0, 0);
        }
        if (this.dimension().width == 2) {
            return this.get(0, 0).multiply(this.get(1, 1)).subtract(this.get(1, 0).multiply(this.get(0, 1)));
        }
        Integer MINUS_ONE = (Integer)Values.ONE.minus();
        Arithmetic det = Values.ZERO;
        Matrix innerMatrix = ((Matrix)this.clone()).removeRow(0);
        for (int j = 0; j < this.dimension().width; ++j) {
            det = det.add(((j & 1) == 0 ? Values.ONE : MINUS_ONE).multiply(this.get(0, j)).multiply(((Matrix)innerMatrix.clone()).removeColumn(j).det()));
        }
        return det;
    }

    public Arithmetic zero() {
        return Values.getDefaultInstance().ZERO(this.dimension());
    }

    public Arithmetic one() {
        if (!this.isSquare()) {
            throw new UnsupportedOperationException("only square matrices have an identity matrix");
        }
        return Values.getDefaultInstance().IDENTITY(this.dimension());
    }

    public Matrix add(Matrix B) {
        return (Matrix)super.add(B);
    }

    public Matrix subtract(Matrix B) {
        return (Matrix)super.subtract(B);
    }

    public Matrix multiply(Matrix B) {
        if (this.dimension().width != B.dimension().height) {
            throw new IllegalArgumentException("Matrix A.B only defined for dimension n x m multiplied with m x l. But not for\n" + this + " *\n" + B);
        }
        Matrix ret = this.newInstance(this.dimension().height, B.dimension().width);
        for (int i = 0; i < ret.dimension().height; ++i) {
            for (int j = 0; j < ret.dimension().width; ++j) {
                ret.set(i, j, this.getRow(i).multiply(B.getColumn(j)));
            }
        }
        return ret;
    }

    public Matrix multiply(Scalar s) {
        return this.scale(s);
    }

    public Matrix scale(Scalar s) {
        return (Matrix)this.scale((Arithmetic)s);
    }

    public Vector multiply(Vector B) {
        Utility.pre(this.dimension().width == B.dimension(), "row vector A.v only defined for Matrix multiplied with row vector of dimension width. " + this.dimension().width + "!=" + B.dimension());
        Vector ret = (Vector)this.newInstance(new int[]{this.dimension().height});
        for (int i = 0; i < ret.dimension(); ++i) {
            ret.set(i, this.getRow(i).multiply(B));
        }
        return ret;
    }

    public Arithmetic add(Arithmetic b) {
        return this.add((Matrix)b);
    }

    public Arithmetic subtract(Arithmetic b) {
        return this.subtract((Matrix)b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Scalar) {
            return this.scale((Scalar)b);
        }
        if (b instanceof Vector) {
            return this.multiply((Vector)b);
        }
        if (b instanceof Matrix) {
            return this.multiply((Matrix)b);
        }
        if (b instanceof Tensor) {
            return super.multiply((Tensor)b);
        }
        throw new IllegalArgumentException("wrong type " + b.getClass());
    }

    public Matrix transpose() {
        Matrix T = this.newInstance(this.dimension().width, this.dimension().height);
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                T.set(j, i, this.get(i, j));
            }
        }
        return T;
    }

    public Matrix conjugate() {
        Matrix T = this.newInstance(this.dimension().width, this.dimension().height);
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                T.set(j, i, ((Complex)this.get(i, j)).conjugate());
            }
        }
        return T;
    }

    public Arithmetic inverse() throws ArithmeticException {
        if (!$assertionsDisabled && !this.isSquare()) {
            throw new AssertionError((Object)("only square matrices can be inverted " + this));
        }
        Matrix A = (Matrix)this.clone();
        Matrix AI = Values.getDefaultInstance().IDENTITY(this.dimension().width, this.dimension().width);
        for (int i = 0; i < this.dimension().width; ++i) {
            Arithmetic ap = A.get(i, i);
            if (ap.norm().equals(Values.ZERO)) {
                throw new UnsupportedOperationException("pivot: diagonal 0s are not expected, must use pivot. found " + ap);
            }
            Arithmetic apinv = ap.inverse();
            Vector urow = (Vector)A.getRow(i).scale(apinv);
            A.setRow(i, urow);
            Vector urowI = (Vector)AI.getRow(i).scale(apinv);
            AI.setRow(i, urowI);
            for (int j = 0; j < this.dimension().height; ++j) {
                Arithmetic f;
                if (j == i || (f = A.get(j, i)).norm().equals(Values.ZERO)) continue;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "Matrix.inverse() \t{0} - {1}\n\t\t{2} - {3}", new Object[]{A.getRow(j), urow.scale(f), AI.getRow(j), urowI.scale(f)});
                }
                A.setRow(j, (Vector)A.getRow(j).subtract(urow.scale(f)));
                AI.setRow(j, (Vector)AI.getRow(j).subtract(urowI.scale(f)));
            }
        }
        if (!A.equals(Values.getDefaultInstance().IDENTITY(this.dimension().width, this.dimension().width), Values.getDefaultInstance().valueOf(MathUtilities.getDefaultTolerance())) && !ValuesImpl.symbolic.apply(A)) {
            logger.log(Level.FINEST, "found a supposed inverse:\n{0}\n but failed to transform to identity matrix:\n{1}\t({2})", new Object[]{AI, A, A.getClass()});
            if (!$assertionsDisabled && this.isInvertible()) {
                throw new AssertionError((Object)"a matrix is singular <=> determinant=0 <=> it cannot be inverted (apart from numerical uncertainty)");
            }
            throw new ArithmeticException("NoninvertibleMatrixException: singular matrix");
        }
        return AI;
    }

    public Matrix pseudoInverse() {
        if (this.dimension().width <= this.dimension().height) {
            Matrix M = this.transpose().multiply(this);
            if (!M.isInvertible()) {
                throw new UnsupportedOperationException("not yet implemented for matrices with lesser rank (ambiguous)");
            }
            return ((Matrix)M.inverse()).multiply(this.transpose());
        }
        Matrix M = this.multiply(this.transpose());
        if (!M.isInvertible()) {
            throw new UnsupportedOperationException("not yet implemented for matrices with lesser rank (ambiguous)");
        }
        return this.transpose().multiply((Matrix)M.inverse());
    }

    public Matrix insertColumns(int index, Matrix cols) {
        if (index != this.dimension().width) {
            this.validate(0, index);
        }
        Utility.pre(this.dimension().height == cols.dimension().height, "Matrix must have same height (number of rows)");
        Arithmetic[][] A = new Arithmetic[this.dimension().height][this.dimension().width + cols.dimension().width];
        for (int i = 0; i < this.dimension().height; ++i) {
            int j;
            for (j = 0; j < index; ++j) {
                A[i][j] = this.get(i, j);
            }
            for (j = 0; j < cols.dimension().width; ++j) {
                A[i][index + j] = cols.get(i, j);
            }
            for (j = index; j < this.dimension().width; ++j) {
                A[i][cols.dimension().width + j] = this.get(i, j);
            }
        }
        this.set(A);
        return this;
    }

    public Matrix insertRows(int index, Matrix rows) {
        int j;
        int i;
        if (index != this.dimension().height) {
            this.validate(index, 0);
        }
        Utility.pre(this.dimension().width == rows.dimension().width, "Matrix must have same width (number of columns)");
        Arithmetic[][] A = new Arithmetic[this.dimension().height + rows.dimension().height][this.dimension().width];
        for (i = 0; i < index; ++i) {
            for (j = 0; j < this.dimension().width; ++j) {
                A[i][j] = this.get(i, j);
            }
        }
        for (i = 0; i < rows.dimension().height; ++i) {
            for (j = 0; j < rows.dimension().width; ++j) {
                A[index + i][j] = rows.get(i, j);
            }
        }
        for (i = index; i < this.dimension().height; ++i) {
            for (j = 0; j < this.dimension().width; ++j) {
                A[rows.dimension().height + i][j] = this.get(i, j);
            }
        }
        this.set(A);
        return this;
    }

    public Matrix insertColumns(Matrix cols) {
        return this.insertColumns(this.dimension().width, cols);
    }

    public Matrix insertRows(Matrix rows) {
        return this.insertRows(this.dimension().height, rows);
    }

    public Matrix removeColumn(int c) {
        this.validate(0, c);
        Arithmetic[][] A = new Arithmetic[this.dimension().height][this.dimension().width - 1];
        for (int i = 0; i < this.dimension().height; ++i) {
            int j;
            for (j = 0; j < c; ++j) {
                A[i][j] = this.get(i, j);
            }
            for (j = c + 1; j < this.dimension().width; ++j) {
                A[i][j - 1] = this.get(i, j);
            }
        }
        this.set(A);
        return this;
    }

    public Matrix removeRow(int r) {
        int j;
        int i;
        this.validate(r, 0);
        Arithmetic[][] A = new Arithmetic[this.dimension().height - 1][this.dimension().width];
        for (i = 0; i < r; ++i) {
            for (j = 0; j < this.dimension().width; ++j) {
                A[i][j] = this.get(i, j);
            }
        }
        for (i = r + 1; i < this.dimension().height; ++i) {
            for (j = 0; j < this.dimension().width; ++j) {
                A[i - 1][j] = this.get(i, j);
            }
        }
        this.set(A);
        return this;
    }

    public final int rank() {
        return 2;
    }

    public final int[] dimensions() {
        Dimension dim = this.dimension();
        return new int[]{dim.height, dim.width};
    }

    public final Arithmetic get(int[] i) {
        this.valid(i);
        return this.get(i[0], i[1]);
    }

    public final void set(int[] i, Arithmetic vi) {
        this.valid(i);
        this.set(i[0], i[1], vi);
    }

    public final Tensor subTensor(int[] i, int[] j) {
        this.valid(i);
        this.valid(j);
        return this.subMatrix(i[0], j[0], i[1], j[1]);
    }

    public final Tensor add(Tensor b) {
        return this.add((Matrix)b);
    }

    public final Tensor subtract(Tensor b) {
        return this.subtract((Matrix)b);
    }

    final void validate(int i, int j) {
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException("Row index (" + i + ") is negative");
        }
        if (j < 0) {
            throw new ArrayIndexOutOfBoundsException("Column index (" + j + ") is negative");
        }
        if (i >= this.dimension().height) {
            throw new ArrayIndexOutOfBoundsException("Row index (" + i + ") out of number of rows (" + this.dimension().height + ")");
        }
        if (j >= this.dimension().width) {
            throw new ArrayIndexOutOfBoundsException("Column index (" + j + ") out of number of columns (" + this.dimension().width + ")");
        }
    }

    final void valid(int[] i) {
        if (i.length != this.rank()) {
            throw new ArrayIndexOutOfBoundsException("illegal number of indices (" + i.length + " indices) for tensor of rank " + this.rank());
        }
        this.validate(i[0], i[1]);
    }

    public Arithmetic[][] toArray() {
        Arithmetic[][] a = new Arithmetic[this.dimension().height][this.dimension().width];
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                a[i][j] = this.get(i, j);
            }
        }
        return a;
    }

    double[][] toDoubleArray() {
        double[][] a = new double[this.dimension().height][this.dimension().width];
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                a[i][j] = this.getDoubleValue(i, j);
            }
        }
        return a;
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    static {
        $assertionsDisabled = !AbstractMatrix.class.desiredAssertionStatus();
        logger = Logger.getLogger(Matrix.class.getName());
    }

    private static class SubMatrix
    extends AbstractMatrix {
        private static final long serialVersionUID = -3683869698064404738L;
        private final AbstractMatrix m;
        private final int columnOffset;
        private final int height;
        private final int rowOffset;
        private final int width;
        private transient int expectedModCount = 0;

        public SubMatrix(AbstractMatrix m, int i1, int i2, int j1, int j2) {
            Utility.pre(i1 <= i2 && j1 <= j2, "Ending row cannot be less than starting row. Ending column cannot be less than starting column");
            m.validate(i1, j1);
            m.validate(i2, j2);
            this.m = m;
            this.rowOffset = i1;
            this.columnOffset = j1;
            this.height = i2 - i1 + 1;
            this.width = j2 - j1 + 1;
            this.expectedModCount = m.modCount;
        }

        protected Matrix newInstance(Dimension dim) {
            this.checkForComodification();
            return this.m.newInstance(dim);
        }

        public final Dimension dimension() {
            this.checkForComodification();
            return new Dimension(this.width, this.height);
        }

        public Arithmetic get(int i, int j) {
            this.validate(i, j);
            this.checkForComodification();
            return this.m.get(i + this.rowOffset, j + this.columnOffset);
        }

        public void set(int i, int j, Arithmetic mij) {
            this.validate(i, j);
            this.checkForComodification();
            this.m.set(i + this.rowOffset, j + this.columnOffset, mij);
        }

        protected void set(Arithmetic[][] v) {
            if (this.dimension().height != v.length || this.dimension().width != v[0].length) {
                throw new UnsupportedOperationException("sub-matrix cannot be altered. clone first");
            }
            this.checkForComodification();
            throw new UnsupportedOperationException("Altering the underlying buffer of a sub-matrix is not yet supported");
        }

        public Object clone() {
            this.checkForComodification();
            return new ArithmeticMatrix(super.toArray());
        }

        private final void checkForComodification() {
            if (this.m.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class RowVector
    extends AbstractVector {
        private static final long serialVersionUID = -4915663894227454973L;
        private final AbstractMatrix m;
        private final int r;

        public RowVector(AbstractMatrix m, int row) {
            m.validate(row, 0);
            this.m = m;
            this.r = row;
        }

        protected Vector newInstance(int dim) {
            return (Vector)this.m.newInstance(new int[]{dim});
        }

        public final int dimension() {
            return this.m.dimension().width;
        }

        public Arithmetic get(int j) {
            return this.m.get(this.r, j);
        }

        public void set(int j, Arithmetic vj) {
            this.m.set(this.r, j, vj);
        }

        protected void set(Arithmetic[] v) {
            if (v.length != this.dimension()) {
                throw new UnsupportedOperationException("row vector cannot be altered. clone first");
            }
            throw new UnsupportedOperationException("Altering the underlying buffer of a row vector is not yet supported");
        }

        public Object clone() {
            return new ArithmeticVector(super.toArray());
        }
    }

    private static class ColumnVector
    extends AbstractVector {
        private static final long serialVersionUID = -5595085518698922020L;
        private final AbstractMatrix m;
        private final int c;

        public ColumnVector(AbstractMatrix m, int column) {
            m.validate(0, column);
            this.m = m;
            this.c = column;
        }

        protected Vector newInstance(int dim) {
            return (Vector)this.m.newInstance(new int[]{dim});
        }

        public final int dimension() {
            return this.m.dimension().height;
        }

        public Arithmetic get(int i) {
            return this.m.get(i, this.c);
        }

        public void set(int i, Arithmetic vi) {
            this.m.set(i, this.c, vi);
        }

        protected void set(Arithmetic[] v) {
            if (v.length != this.dimension()) {
                throw new UnsupportedOperationException("column vector cannot be altered. clone first");
            }
            throw new UnsupportedOperationException("Altering the underlying buffer of a column vector is not yet supported");
        }

        public Object clone() {
            return new ArithmeticVector(super.toArray());
        }
    }
}

