/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Euclidean;
import orbital.math.MathUtilities;
import orbital.math.Quotient;
import orbital.math.Real;
import orbital.math.Values;
import orbital.util.Utility;

class AbstractQuotient
implements Quotient,
Serializable {
    private static final long serialVersionUID = 5546024068517708793L;
    protected final Function quotientOperator;
    protected Arithmetic value;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractQuotient(Arithmetic val, Function mod) {
        this.quotientOperator = mod;
        this.value = val == null ? null : (Arithmetic)this.quotientOperator.apply(val);
    }

    public AbstractQuotient(Euclidean val, Euclidean m) {
        this((Arithmetic)val, new EuclideanModulo(m));
    }

    public boolean equals(Object x) {
        if (x instanceof Quotient) {
            Quotient b = (Quotient)x;
            return this.getQuotientOperator().equals(b.getQuotientOperator()) && this.representative().equals(b.representative());
        }
        return false;
    }

    public boolean equals(Object x, Real tolerance) {
        if (x instanceof Quotient) {
            Quotient b = (Quotient)x;
            return this.getQuotientOperator().equals(b.getQuotientOperator()) && this.representative().equals(b.representative(), tolerance);
        }
        return false;
    }

    public int hashCode() {
        return this.representative().hashCode() ^ this.getQuotientOperator().hashCode();
    }

    public Function getQuotientOperator() {
        return this.quotientOperator;
    }

    public Arithmetic representative() {
        return this.value;
    }

    private final Quotient equivalenceClass(Arithmetic v) {
        return new AbstractQuotient(v, this.getQuotientOperator());
    }

    public Real norm() {
        return this.representative().norm();
    }

    public Arithmetic zero() {
        return this.equivalenceClass(this.representative().zero());
    }

    public Arithmetic one() {
        return this.equivalenceClass(this.representative().one());
    }

    public Quotient add(Quotient b) throws ArithmeticException {
        if (!this.getQuotientOperator().equals(b.getQuotientOperator())) {
            throw new ArithmeticException("different modulus " + this.getQuotientOperator() + "!=" + b.getQuotientOperator());
        }
        return this.equivalenceClass(this.representative().add(b.representative()));
    }

    public Quotient subtract(Quotient b) {
        if (!this.getQuotientOperator().equals(b.getQuotientOperator())) {
            throw new ArithmeticException("different modulus " + this.getQuotientOperator() + "!=" + b.getQuotientOperator());
        }
        return this.equivalenceClass(this.representative().subtract(b.representative()));
    }

    public Arithmetic scale(Arithmetic alpha) {
        return this.equivalenceClass(this.representative().scale(alpha));
    }

    public Quotient multiply(Quotient b) {
        if (!this.getQuotientOperator().equals(b.getQuotientOperator())) {
            throw new ArithmeticException("different modulus " + this.getQuotientOperator() + "!=" + b.getQuotientOperator());
        }
        return this.equivalenceClass(this.representative().multiply(b.representative()));
    }

    public Quotient divide(Quotient b) throws ArithmeticException {
        if (!this.getQuotientOperator().equals(b.getQuotientOperator())) {
            throw new ArithmeticException("different modulus " + this.getQuotientOperator() + "!=" + b.getQuotientOperator());
        }
        return this.equivalenceClass(this.representative().divide(b.representative()));
    }

    public Arithmetic inverse() throws ArithmeticException {
        Function quotientOperator = this.getQuotientOperator();
        if (quotientOperator instanceof EuclideanModulo) {
            Euclidean m = ((EuclideanModulo)quotientOperator).getModulus();
            if (!$assertionsDisabled && !(this.representative() instanceof Euclidean)) {
                throw new AssertionError((Object)"Euclidean modulo requires elements of the Euclidean ring");
            }
            Euclidean[] r = MathUtilities.gcd(new Euclidean[]{(Euclidean)this.representative(), m});
            if (r[r.length - 1].one().equals(r[r.length - 1])) {
                return r[0];
            }
            throw new ArithmeticException("not invertible since (" + this.representative() + ", " + m + ") are not coprime");
        }
        try {
            return this.equivalenceClass(this.representative().inverse());
        }
        catch (ArithmeticException unable) {
            throw new UnsupportedOperationException("can only invert quotients with non-invertible representatives in Euclidean rings");
        }
        catch (UnsupportedOperationException unable) {
            throw new UnsupportedOperationException("can only invert quotients with non-invertible representatives in Euclidean rings");
        }
    }

    public Quotient power(Quotient b) throws ArithmeticException {
        return this.equivalenceClass(this.representative().power(b));
    }

    public Arithmetic add(Arithmetic b) {
        return this.add((Quotient)b);
    }

    public Arithmetic subtract(Arithmetic b) {
        return this.subtract((Quotient)b);
    }

    public Arithmetic minus() {
        return this.equivalenceClass(this.representative().minus());
    }

    public Arithmetic multiply(Arithmetic b) {
        return this.multiply((Quotient)b);
    }

    public Arithmetic divide(Arithmetic b) {
        return this.divide((Quotient)b);
    }

    public Arithmetic power(Arithmetic b) {
        return this.power((Quotient)b);
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    static {
        $assertionsDisabled = !AbstractQuotient.class.desiredAssertionStatus();
    }

    private static class EuclideanModulo
    implements Function,
    Serializable {
        private static final long serialVersionUID = -8846695670222356251L;
        private final Euclidean m;

        public EuclideanModulo(Euclidean m) {
            this.m = m.norm().equals(Values.ZERO) ? null : m;
        }

        public boolean equals(Object o) {
            return o instanceof EuclideanModulo && Utility.equals(this.m, ((EuclideanModulo)o).m);
        }

        public int hashCode() {
            return Utility.hashCode(this.m);
        }

        public Euclidean getModulus() {
            return this.m;
        }

        public Object apply(Object a) {
            return this.m == null ? a : ((Euclidean)a).modulo(this.m);
        }
    }
}

