/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Dimension;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyPermission;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.Euclidean;
import orbital.math.Integer;
import orbital.math.Matrix;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.ValueFactory;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.moon.math.AbstractMatrix;
import orbital.moon.math.AbstractTensor;
import orbital.moon.math.AbstractVector;
import orbital.moon.math.ArithmeticMultivariatePolynomial;
import orbital.moon.math.ArithmeticVector;
import orbital.moon.math.RMatrix;
import orbital.moon.math.RVector;
import orbital.util.Setops;

public abstract class AbstractValues
extends Values {
    private Function coercer = null;
    private Function normalizer = null;
    private Map parameters = Collections.EMPTY_MAP;
    private final Integer ZEROImpl = this.valueOf(0);
    private final Integer ONEImpl = this.valueOf(1);
    private final Integer MINUS_ONEImpl = this.valueOf(-1);
    private final Real POSITIVE_INFINITYImpl = this.valueOf(Double.POSITIVE_INFINITY);
    private final Real NEGATIVE_INFINITYImpl = this.valueOf(Double.NEGATIVE_INFINITY);
    private final Real PIImpl = this.valueOf(Math.PI);
    private final Real EImpl = this.valueOf(Math.E);
    private final Real NaNImpl = this.valueOf(Double.NaN);
    private final Complex IImpl = this.complex(0, 1);
    private final Complex INFINITYImpl = this.complex(Double.POSITIVE_INFINITY, Double.NaN);
    static /* synthetic */ Class class$orbital$moon$math$AbstractValues;

    protected AbstractValues() {
    }

    protected AbstractValues(Function coercer) {
        this.coercer = coercer;
    }

    protected AbstractValues(Function coercer, Function normalizer) {
        this.coercer = coercer;
        this.normalizer = normalizer;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    protected Map getParameters() {
        return this.parameters;
    }

    public Integer ZERO() {
        return this.ZEROImpl;
    }

    public Integer ONE() {
        return this.ONEImpl;
    }

    public Integer MINUS_ONE() {
        return this.MINUS_ONEImpl;
    }

    public Real POSITIVE_INFINITY() {
        return this.POSITIVE_INFINITYImpl;
    }

    public Real NEGATIVE_INFINITY() {
        return this.NEGATIVE_INFINITYImpl;
    }

    public Real PI() {
        return this.PIImpl;
    }

    public Real E() {
        return this.EImpl;
    }

    public Real NaN() {
        return this.NaNImpl;
    }

    public Complex I() {
        return this.IImpl;
    }

    public Complex i() {
        return this.IImpl;
    }

    public Complex INFINITY() {
        return this.INFINITYImpl;
    }

    public Scalar valueOf(Number val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Scalar) {
            return (Scalar)((Object)val);
        }
        if (val instanceof java.lang.Integer) {
            return this.valueOf((java.lang.Integer)val);
        }
        if (val instanceof Long) {
            return this.valueOf((Long)val);
        }
        if (val instanceof Double) {
            return this.valueOf((Double)val);
        }
        if (val instanceof Float) {
            return this.valueOf((Float)val);
        }
        if (val instanceof Byte) {
            return this.valueOf((Byte)val);
        }
        if (val instanceof Short) {
            return this.valueOf((Short)val);
        }
        if (val instanceof BigInteger) {
            return this.valueOf((BigInteger)val);
        }
        if (val instanceof BigDecimal) {
            return this.valueOf((BigDecimal)val);
        }
        return this.narrow(this.valueOf(val.doubleValue()));
    }

    public Integer valueOf(java.lang.Integer val) {
        return this.valueOf((int)val);
    }

    public Integer valueOf(Long val) {
        return this.valueOf((long)val);
    }

    public Integer valueOf(Byte val) {
        return this.valueOf((byte)val);
    }

    public Integer valueOf(Short val) {
        return this.valueOf((short)val);
    }

    public Real valueOf(Double val) {
        return this.valueOf((double)val);
    }

    public Real valueOf(Float val) {
        return this.valueOf(val.floatValue());
    }

    public Rational rational(int p, int q) {
        return this.rational(this.valueOf(p), this.valueOf(q));
    }

    public Rational rational(int p) {
        return this.rational(this.valueOf(p));
    }

    public Complex complex(double a, double b) {
        return this.complex(this.valueOf(a), this.valueOf(b));
    }

    public Complex complex(float a, float b) {
        return this.complex(this.valueOf(a), this.valueOf(b));
    }

    public Complex complex(int a, int b) {
        return this.complex(this.valueOf(a), this.valueOf(b));
    }

    public Complex complex(long a, long b) {
        return this.complex(this.valueOf(a), this.valueOf(b));
    }

    public Complex complex(double a) {
        return this.complex(this.valueOf(a));
    }

    public Complex cartesian(double a, double b) {
        return this.cartesian(this.valueOf(a), this.valueOf(b));
    }

    public Complex polar(double r, double phi) {
        return this.polar(this.valueOf(r), this.valueOf(phi));
    }

    public Vector ZERO(int n) {
        return this.CONST(n, Values.ZERO);
    }

    public Vector constant(final Vector v) {
        return new AbstractVector(){
            private static final long serialVersionUID = 4473448798599904941L;
            static final /* synthetic */ boolean $assertionsDisabled;

            protected Vector newInstance(int d) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"this method should never get called in this context of constant(...)");
                }
                return ((AbstractVector)v).newInstance(d);
            }

            public int dimension() {
                return v.dimension();
            }

            public Arithmetic get(int i) {
                return v.get(i);
            }

            public void set(int i, Arithmetic vi) {
                throw new UnsupportedOperationException();
            }

            protected void set(Arithmetic[] vs) {
                throw new UnsupportedOperationException();
            }

            public ListIterator iterator() {
                return Setops.unmodifiableListIterator(v.iterator());
            }

            public boolean equals(Object b) {
                return v.equals(b);
            }

            public int hashCode() {
                return v.hashCode();
            }

            public Object clone() {
                return v.clone();
            }

            public Real norm() {
                return v.norm();
            }

            public Real norm(double p) {
                return v.norm(p);
            }

            public Arithmetic add(Arithmetic b) {
                return v.add(b);
            }

            public Arithmetic subtract(Arithmetic b) {
                return v.subtract(b);
            }

            public Arithmetic minus() {
                return v.minus();
            }

            public Arithmetic multiply(Arithmetic b) {
                return v.multiply(b);
            }

            public Arithmetic scale(Arithmetic b) {
                return v.scale(b);
            }

            public Arithmetic inverse() {
                return v.inverse();
            }

            public Arithmetic divide(Arithmetic b) {
                return v.divide(b);
            }

            public Arithmetic power(Arithmetic b) {
                return v.power(b);
            }

            public Vector cross(Vector b) {
                return v.cross(b);
            }

            public Matrix transpose() {
                return v.transpose();
            }

            public Vector insert(int i, Arithmetic b) {
                throw new UnsupportedOperationException();
            }

            public Vector insert(int i, Vector b) {
                throw new UnsupportedOperationException();
            }

            public Vector append(Arithmetic b) {
                throw new UnsupportedOperationException();
            }

            public Vector append(Vector b) {
                throw new UnsupportedOperationException();
            }

            public Vector remove(int i) {
                throw new UnsupportedOperationException();
            }

            public Arithmetic[] toArray() {
                return v.toArray();
            }

            public String toString() {
                return v.toString();
            }

            static {
                $assertionsDisabled = !(class$orbital$moon$math$AbstractValues == null ? (class$orbital$moon$math$AbstractValues = AbstractValues.class$("orbital.moon.math.AbstractValues")) : class$orbital$moon$math$AbstractValues).desiredAssertionStatus();
            }
        };
    }

    public Matrix ZERO(Dimension dim) {
        return this.ZERO(dim.height, dim.width);
    }

    public Matrix ZERO(int height, int width) {
        return (Matrix)this.ZERO(new int[]{height, width});
    }

    public Matrix IDENTITY(Dimension dim) {
        return this.IDENTITY(dim.height, dim.width);
    }

    public Matrix DIAGONAL(Vector diagon) {
        Matrix diagonal = this.newInstance(new Dimension(diagon.dimension(), diagon.dimension()));
        for (int i = 0; i < diagonal.dimension().height; ++i) {
            for (int j = 0; j < diagonal.dimension().width; ++j) {
                diagonal.set(i, j, i == j ? diagon.get(i) : ZERO);
            }
        }
        return diagonal;
    }

    public Matrix constant(final Matrix m) {
        return new AbstractMatrix(){
            private static final long serialVersionUID = 482711902153502751L;
            static final /* synthetic */ boolean $assertionsDisabled;

            protected Matrix newInstance(Dimension d) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"this method should never get called in this context of constant(...)");
                }
                return ((AbstractMatrix)m).newInstance(d);
            }

            public Dimension dimension() {
                return m.dimension();
            }

            public Arithmetic get(int i, int j) {
                return m.get(i, j);
            }

            public void set(int i, int j, Arithmetic v) {
                throw new UnsupportedOperationException();
            }

            public Vector getColumn(int j) {
                return m.getColumn(j);
            }

            public void setColumn(int j, Vector v) {
                throw new UnsupportedOperationException();
            }

            public Vector getRow(int i) {
                return m.getRow(i);
            }

            public void setRow(int i, Vector v) {
                throw new UnsupportedOperationException();
            }

            public void set(Arithmetic[][] v) {
                throw new UnsupportedOperationException();
            }

            public ListIterator getColumns() {
                return Setops.unmodifiableListIterator(m.getColumns());
            }

            public ListIterator getRows() {
                return Setops.unmodifiableListIterator(m.getRows());
            }

            public ListIterator iterator() {
                return Setops.unmodifiableListIterator(m.iterator());
            }

            public Vector getDiagonal() {
                return m.getDiagonal();
            }

            public boolean isSquare() {
                return m.isSquare();
            }

            public boolean isSymmetric() throws ArithmeticException {
                return m.isSymmetric();
            }

            public boolean isInvertible() throws ArithmeticException {
                return m.isInvertible();
            }

            public int isDefinite() throws ArithmeticException {
                return m.isDefinite();
            }

            public boolean equals(Object b) {
                return m.equals(b);
            }

            public int hashCode() {
                return m.hashCode();
            }

            public Object clone() {
                return m.clone();
            }

            public Matrix subMatrix(int r1, int r2, int c1, int c2) {
                return m.subMatrix(r1, r2, c1, c2);
            }

            public Real norm() {
                return m.norm();
            }

            public Real norm(double p) {
                return m.norm(p);
            }

            public Arithmetic trace() {
                return m.trace();
            }

            public Arithmetic det() {
                return m.det();
            }

            public Arithmetic add(Arithmetic b) {
                return m.add(b);
            }

            public Arithmetic minus() {
                return m.minus();
            }

            public Arithmetic subtract(Arithmetic b) {
                return m.subtract(b);
            }

            public Arithmetic multiply(Arithmetic b) {
                return m.multiply(b);
            }

            public Arithmetic scale(Arithmetic b) {
                return m.scale(b);
            }

            public Arithmetic inverse() {
                return m.inverse();
            }

            public Arithmetic divide(Arithmetic b) {
                return m.divide(b);
            }

            public Arithmetic power(Arithmetic b) {
                return m.power(b);
            }

            public Matrix add(Matrix b) {
                return m.add(b);
            }

            public Matrix subtract(Matrix b) {
                return m.subtract(b);
            }

            public Matrix multiply(Matrix b) {
                return m.multiply(b);
            }

            public Matrix scale(Scalar b) {
                return m.scale(b);
            }

            public Vector multiply(Vector b) {
                return m.multiply(b);
            }

            public Matrix transpose() {
                return m.transpose();
            }

            public Matrix pseudoInverse() {
                return m.pseudoInverse();
            }

            public Matrix appendColumns(Matrix b) {
                throw new UnsupportedOperationException();
            }

            public Matrix appendRows(Matrix b) {
                throw new UnsupportedOperationException();
            }

            public Matrix insertColumns(int i, Matrix b) {
                throw new UnsupportedOperationException();
            }

            public Matrix insertRows(int i, Matrix b) {
                throw new UnsupportedOperationException();
            }

            public Matrix removeColumn(int j) {
                throw new UnsupportedOperationException();
            }

            public Matrix removeRow(int i) {
                throw new UnsupportedOperationException();
            }

            public Arithmetic[][] toArray() {
                return m.toArray();
            }

            public String toString() {
                return m.toString();
            }

            static {
                $assertionsDisabled = !(class$orbital$moon$math$AbstractValues == null ? (class$orbital$moon$math$AbstractValues = AbstractValues.class$("orbital.moon.math.AbstractValues")) : class$orbital$moon$math$AbstractValues).desiredAssertionStatus();
            }
        };
    }

    public Tensor ZERO(int[] dimensions) {
        Tensor zero = this.newInstance(dimensions);
        ListIterator i = zero.iterator();
        while (i.hasNext()) {
            i.next();
            i.set(Values.ZERO);
        }
        return zero;
    }

    public Tensor constant(final Tensor t) {
        return new AbstractTensor(){
            private static final long serialVersionUID = 3658988168257832220L;
            static final /* synthetic */ boolean $assertionsDisabled;

            protected Tensor newInstance(int[] dim) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"this method should never get called in this context of constant(...)");
                }
                return ((AbstractTensor)t).newInstance(dim);
            }

            public Real norm() {
                return t.norm();
            }

            public Object clone() {
                return t.clone();
            }

            public Tensor add(Tensor param1) {
                return t.add(param1);
            }

            public Arithmetic get(int[] param1) {
                return t.get(param1);
            }

            public ListIterator iterator() {
                return t.iterator();
            }

            public void set(int[] param1, Arithmetic param2) throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public int[] dimensions() {
                return t.dimensions();
            }

            public int rank() {
                return t.rank();
            }

            public Tensor subTensor(int[] param1, int[] param2) {
                return t.subTensor(param1, param2);
            }

            public Tensor subtract(Tensor param1) {
                return t.subtract(param1);
            }

            public Tensor multiply(Tensor param1) {
                return t.multiply(param1);
            }

            public Tensor tensor(Tensor param1) {
                return t.tensor(param1);
            }

            public boolean equals(Object param1, Real param2) {
                return t.equals(param1, param2);
            }

            public String toString() {
                return t.toString();
            }

            public Arithmetic add(Arithmetic param1) throws ArithmeticException {
                return t.add(param1);
            }

            public Arithmetic subtract(Arithmetic param1) throws ArithmeticException {
                return t.subtract(param1);
            }

            public Arithmetic multiply(Arithmetic param1) throws ArithmeticException, UnsupportedOperationException {
                return t.multiply(param1);
            }

            public Arithmetic zero() throws ArithmeticException {
                return t.zero();
            }

            public Arithmetic one() throws UnsupportedOperationException {
                return t.one();
            }

            public Arithmetic minus() throws ArithmeticException {
                return t.minus();
            }

            public Arithmetic inverse() throws ArithmeticException, UnsupportedOperationException {
                return t.inverse();
            }

            public Arithmetic divide(Arithmetic param1) throws ArithmeticException, UnsupportedOperationException {
                return t.divide(param1);
            }

            public Arithmetic scale(Arithmetic param1) throws ArithmeticException, UnsupportedOperationException {
                return t.scale(param1);
            }

            public Arithmetic power(Arithmetic param1) throws ArithmeticException, UnsupportedOperationException {
                return t.power(param1);
            }

            static {
                $assertionsDisabled = !(class$orbital$moon$math$AbstractValues == null ? (class$orbital$moon$math$AbstractValues = AbstractValues.class$("orbital.moon.math.AbstractValues")) : class$orbital$moon$math$AbstractValues).desiredAssertionStatus();
            }
        };
    }

    public final Polynomial MONOMIAL(Arithmetic coefficient, Arithmetic exponent) {
        return this.MONOMIAL(coefficient, ArithmeticMultivariatePolynomial.convertIndex(exponent));
    }

    public final Polynomial MONOMIAL(Arithmetic exponent) {
        return this.MONOMIAL((Arithmetic)ONE, exponent);
    }

    public final Polynomial MONOMIAL(int[] exponents) {
        return this.MONOMIAL((Arithmetic)ONE, exponents);
    }

    public UnivariatePolynomial polynomial(double[] coefficients) {
        return (UnivariatePolynomial)this.polynomial((Object)coefficients);
    }

    public UnivariatePolynomial polynomial(int[] coefficients) {
        return (UnivariatePolynomial)this.polynomial((Object)coefficients);
    }

    public Vector asVector(UnivariatePolynomial p) {
        return (Vector)this.asTensor(p);
    }

    public Quotient quotient(Euclidean a, UnivariatePolynomial m) {
        return this.quotient(a, (Euclidean)m);
    }

    public Quotient quotient(Euclidean a, Function mod) {
        return this.quotient((Arithmetic)a, mod);
    }

    public Quotient quotient(Arithmetic a, Polynomial m) {
        if (a instanceof Euclidean && m instanceof Euclidean) {
            return this.quotient((Euclidean)a, (Euclidean)((Object)m));
        }
        throw new ClassCastException(m.getClass() + " most probably is no quotient operator.\nConsider using Values.quotient(Polynomial,Set,Comparator) instead.\nIf the instance " + m + " truely is a quotient operator\nand you really know what you are doing, then call Values.quotient(Arithmetic,Function) instead.");
    }

    public Quotient quotient(int a, int m) {
        return this.quotient((Euclidean)this.valueOf(a), this.valueOf(m));
    }

    public Vector asVector(final Matrix m) {
        return new AbstractVector(){
            private static final long serialVersionUID = 7697252236109892826L;

            protected Vector newInstance(int dim) {
                return m instanceof RMatrix ? new RVector(dim) : new ArithmeticVector(dim);
            }

            public int dimension() {
                Dimension dim = m.dimension();
                return dim.height * dim.width;
            }

            private int rowOf(int i) {
                return i / m.dimension().width;
            }

            private int columnOf(int i) {
                return i % m.dimension().width;
            }

            public Arithmetic get(int i) {
                return m.get(this.rowOf(i), this.columnOf(i));
            }

            public void set(int i, Arithmetic v) {
                m.set(this.rowOf(i), this.columnOf(i), v);
            }

            protected void set(Arithmetic[] v) {
                throw new UnsupportedOperationException("not currently supported");
            }

            public ListIterator iterator() {
                return m.iterator();
            }

            public Object clone() {
                throw new UnsupportedOperationException("@xxx dunno");
            }

            public Vector insert(int i, Arithmetic b) {
                throw new UnsupportedOperationException("structurally unmodifiable view");
            }

            public Vector insert(int i, Vector b) {
                throw new UnsupportedOperationException("structurally unmodifiable view");
            }

            public Vector append(Arithmetic b) {
                throw new UnsupportedOperationException("structurally unmodifiable view");
            }

            public Vector append(Vector b) {
                throw new UnsupportedOperationException("structurally unmodifiable view");
            }

            public Vector remove(int i) {
                throw new UnsupportedOperationException("structurally unmodifiable view");
            }
        };
    }

    public Vector asVector(Tensor t) {
        if (t instanceof Vector) {
            return (Vector)t;
        }
        if (t instanceof Matrix) {
            return this.asVector((Matrix)t);
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    public final Function getCoercer() {
        return this.coercer;
    }

    protected final void initialSetCoercer(Function coercer) {
        this.coercer = coercer;
    }

    public final void setCoercer(Function coercer) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(ValueFactory.class.getName() + ".coercer", "write"));
        }
        this.initialSetCoercer(coercer);
    }

    public final Function getNormalizer() {
        return this.normalizer;
    }

    protected final void initialSetNormalizer(Function normalizer) {
        this.normalizer = normalizer;
    }

    public final void setNormalizer(Function normalizer) throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new PropertyPermission(ValueFactory.class.getName() + ".normalizer", "write"));
        }
        this.initialSetNormalizer(normalizer);
    }
}

