/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.awt.Dimension;
import java.util.Arrays;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functions;
import orbital.moon.math.AbstractMatrix;
import orbital.moon.math.ArithmeticMatrix;
import orbital.moon.math.RVector;
import orbital.util.Utility;

class RMatrix
extends AbstractMatrix {
    private static final long serialVersionUID = -5257297603569417580L;
    protected double[][] D;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static final Matrix ZERO(Dimension dim) {
        RMatrix zero = new RMatrix(dim.height, dim.width);
        for (int i = 0; i < zero.dimension().height; ++i) {
            Arrays.fill(zero.D[i], 0.0);
        }
        return zero;
    }

    public static final Matrix ZERO(int size) {
        return RMatrix.ZERO(new Dimension(size, size));
    }

    public static final Matrix IDENTITY(int size) {
        RMatrix identity = new RMatrix(size, size);
        for (int i = 0; i < identity.dimension().height; ++i) {
            for (int j = 0; j < identity.dimension().width; ++j) {
                identity.D[i][j] = Functions.delta(i, j);
            }
        }
        return identity;
    }

    public static final Matrix IDENTITY(Dimension dim) {
        Utility.pre(dim.width == dim.height, "identity matrix is square");
        return RMatrix.IDENTITY(dim.width);
    }

    public static final Matrix DIAGONAL(Vector diagon) {
        RMatrix diagonal = new RMatrix(diagon.dimension(), diagon.dimension());
        for (int j = 0; j < diagonal.dimension().height; ++j) {
            for (int i = 0; i < diagonal.dimension().width; ++i) {
                diagonal.D[j][i] = (double)Functions.delta(i, j) * ((Number)((Object)diagon.get(i))).doubleValue();
            }
        }
        return diagonal;
    }

    public static final Matrix HILBERT(int width, int height) {
        RMatrix hilbert = new RMatrix(height, width);
        for (int j = 0; j < hilbert.dimension().height; ++j) {
            for (int i = 0; i < hilbert.dimension().width; ++i) {
                hilbert.D[j][i] = 1.0 / (double)(i + j + 1);
            }
        }
        return hilbert;
    }

    public static final Matrix HILBERT(int size) {
        return RMatrix.HILBERT(size, size);
    }

    public RMatrix(int height, int width) {
        this.D = new double[height][width];
    }

    public RMatrix(Dimension dim) {
        this(dim.height, dim.width);
    }

    public RMatrix(double[][] values) {
        this.set(values);
    }

    public RMatrix(Arithmetic[][] v) {
        int i;
        for (i = 1; i < v.length; ++i) {
            Utility.pre(v[i].length == v[i - 1].length, "rectangular array required");
        }
        this.D = new double[v.length][v[0].length];
        for (i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                this.D[i][j] = ((Number)((Object)v[i][j])).doubleValue();
            }
        }
    }

    protected Matrix newInstance(Dimension dim) {
        return new RMatrix(dim);
    }

    public Object clone() {
        return new RMatrix(this.toDoubleArray());
    }

    public final Dimension dimension() {
        return new Dimension(this.D.length != 0 ? this.D[0].length : 0, this.D.length);
    }

    public Arithmetic get(int i, int j) {
        return Values.getDefaultInstance().valueOf(this.getDoubleValue(i, j));
    }

    public double getDoubleValue(int i, int j) {
        this.validate(i, j);
        return this.D[i][j];
    }

    public void set(int i, int j, Arithmetic m) {
        this.set(i, j, ((Number)((Object)m)).doubleValue());
    }

    public void set(int i, int j, double m) {
        this.validate(i, j);
        this.D[i][j] = m;
    }

    public void setColumn(int c, double[] col) {
        this.setColumn(c, new RVector(col));
    }

    public Vector getRow(int r) {
        this.validate(r, 0);
        return new RVector(this.D[r]);
    }

    public void setRow(int r, double[] row) {
        this.validate(r, row.length - 1);
        this.D[r] = (double[])row.clone();
    }

    public void setRow(int r, Vector row) throws UnsupportedOperationException {
        if (row instanceof RVector) {
            this.setRow(r, ((RVector)row).D);
        } else {
            super.setRow(r, row);
        }
    }

    protected void set(double[][] v) {
        this.D = new double[v.length][];
        for (int i = 0; i < v.length; ++i) {
            if (i > 0) {
                Utility.pre(v[i].length == v[i - 1].length, "rectangular array required for matrix");
            }
            this.D[i] = (double[])v[i].clone();
        }
        ++this.modCount;
    }

    protected void set(Arithmetic[][] v) {
        this.D = new double[v.length][v[0].length];
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                this.set(i, j, v[i][j]);
            }
        }
        ++this.modCount;
    }

    public Arithmetic det() {
        return Values.getDefaultInstance().valueOf(this.determinantImpl());
    }

    private double determinantImpl() {
        if (!this.isSquare()) {
            throw new ArithmeticException("determinant only defined for square matrices");
        }
        if (this.dimension().width == 1) {
            return this.getDoubleValue(0, 0);
        }
        if (this.dimension().width == 2) {
            return this.getDoubleValue(0, 0) * this.getDoubleValue(1, 1) - this.getDoubleValue(1, 0) * this.getDoubleValue(0, 1);
        }
        double det = 0.0;
        Matrix innerMatrix = ((Matrix)this.clone()).removeRow(0);
        for (int j = 0; j < this.dimension().width; ++j) {
            det += (double)((j & 1) == 0 ? 1 : -1) * this.getDoubleValue(0, j) * ((RMatrix)((Matrix)innerMatrix.clone()).removeColumn(j)).determinantImpl();
        }
        return det;
    }

    public Matrix add(Matrix B) {
        if (!(B instanceof RMatrix)) {
            return new ArithmeticMatrix(this.toArray()).add(B);
        }
        Utility.pre(this.dimension().equals(B.dimension()), "Matrix A+B only defined for equal dimension");
        RMatrix b = (RMatrix)B;
        RMatrix ret = new RMatrix(this.dimension());
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                ret.D[i][j] = this.D[i][j] + b.D[i][j];
            }
        }
        return ret;
    }

    public Matrix subtract(Matrix B) {
        if (!(B instanceof RMatrix)) {
            return new ArithmeticMatrix(this.toArray()).subtract(B);
        }
        Utility.pre(this.dimension().equals(B.dimension()), "Matrix A-B only defined for equal dimension");
        RMatrix b = (RMatrix)B;
        RMatrix ret = new RMatrix(this.dimension());
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                ret.D[i][j] = this.D[i][j] - b.D[i][j];
            }
        }
        return ret;
    }

    public Matrix multiply(Matrix B) {
        if (!(B instanceof RMatrix)) {
            return new ArithmeticMatrix(this.toArray()).multiply(B);
        }
        Utility.pre(this.dimension().width == B.dimension().height, "Matrix A.B only defined for dimension n by m multiplied with m by l");
        RMatrix b = (RMatrix)B;
        RMatrix ret = new RMatrix(this.dimension().height, B.dimension().width);
        if (!$assertionsDisabled && !ret.equals(RMatrix.ZERO(ret.dimension()))) {
            throw new AssertionError((Object)"initialization of double[][] to 0 by system");
        }
        for (int i = 0; i < ret.dimension().height; ++i) {
            for (int k = 0; k < this.D[i].length; ++k) {
                double r = this.D[i][k];
                for (int j = 0; j < ret.dimension().width; ++j) {
                    double[] dArray = ret.D[i];
                    int n = j;
                    dArray[n] = dArray[n] + r * b.D[k][j];
                }
            }
        }
        return ret;
    }

    public Matrix scale(double s) {
        RMatrix ret = new RMatrix(this.dimension());
        for (int i = 0; i < this.dimension().height; ++i) {
            for (int j = 0; j < this.dimension().width; ++j) {
                ret.D[i][j] = this.D[i][j] * s;
            }
        }
        return ret;
    }

    public Arithmetic scale(Arithmetic s) {
        if (!Real.isa.apply(s)) {
            return new ArithmeticMatrix(this.toArray()).scale(s);
        }
        return this.scale(((Real)s).doubleValue());
    }

    public Matrix insertRows(int index, Matrix rows) {
        int i;
        int i2;
        if (index != this.dimension().height) {
            this.validate(index, 0);
        }
        Utility.pre(this.dimension().width == rows.dimension().width, "Matrix must have same width (number of columns)");
        double[][] A = new double[this.dimension().height + rows.dimension().height][this.dimension().width];
        for (i2 = 0; i2 < index; ++i2) {
            A[i2] = this.D[i2];
        }
        if (rows instanceof RMatrix) {
            RMatrix m = (RMatrix)rows;
            for (i = 0; i < rows.dimension().height; ++i) {
                A[index + i] = m.D[i];
            }
        } else if (rows instanceof AbstractMatrix) {
            AbstractMatrix m = (AbstractMatrix)rows;
            for (i = 0; i < m.dimension().height; ++i) {
                for (int j = 0; j < m.dimension().width; ++j) {
                    A[index + i][j] = m.getDoubleValue(i, j);
                }
            }
        } else {
            for (i2 = 0; i2 < rows.dimension().height; ++i2) {
                for (int j = 0; j < rows.dimension().width; ++j) {
                    A[index + i2][j] = ((Real)rows.get(i2, j)).doubleValue();
                }
            }
        }
        for (int i3 = index; i3 < this.dimension().height; ++i3) {
            A[rows.dimension().height + i3] = this.D[i3];
        }
        this.set(A);
        return this;
    }

    public Matrix removeRow(int r) {
        int i;
        this.validate(r, 0);
        double[][] A = new double[this.dimension().height - 1][this.dimension().width];
        for (i = 0; i < r; ++i) {
            A[i] = this.D[i];
        }
        for (i = r + 1; i < this.dimension().height; ++i) {
            A[i - 1] = this.D[i];
        }
        this.set(A);
        return this;
    }

    public double[][] toDoubleArray() {
        double[][] v = new double[this.D.length][];
        for (int i = 0; i < v.length; ++i) {
            v[i] = (double[])this.D[i].clone();
        }
        return v;
    }

    static {
        $assertionsDisabled = !RMatrix.class.desiredAssertionStatus();
    }
}

